<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method exportByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method closeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单列表
     *
     * @support  array $cond.createdAtRange 创建时间区间 
     * @support  string $cond.orderNum 订单号 
     * @support  string $cond.userName 用户姓名 
     * @support  string $cond.phone 用户手机号 
     * @support  array $cond.states 订单状态s 
     * @support  array $cond.orderItemStates 订单项状态 
     * @support  array $cond.orderItemSecondRetouchStates 订单项看片状态 
     * @support  string $cond.from 账号来源 
     * @support  int $cond.userId 用户id [Original type uint] 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 导出订单s
     *
     * @support  array $cond.createdAtRange 创建时间区间 
     * @support  string $cond.orderNum 订单号 
     * @support  string $cond.userName 用户姓名 
     * @support  string $cond.phone 用户手机号 
     * @support  array $cond.states 订单状态s 
     * @support  array $cond.orderItemStates 订单项状态 
     * @support  array $cond.orderItemSecondRetouchStates 订单项看片状态 
     * @support  string $cond.from 账号来源 
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 订单详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $reason reason [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}