<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderInfoByNumByParams(array $params)
 * @method batchGetOrderInfoByNumsByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 【桥】根据订单号获取订单信息
     *
     * @param  string $orderNum 订单num [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfoByNum (string $orderNum) {
        return self::getClass()->getOrderInfoByNum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 【桥】批量根据订单号获取订单信息
     *
     * @param  array $orderNums 订单nums [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetOrderInfoByNums (array $orderNums) {
        return self::getClass()->batchGetOrderInfoByNums([
            "orderNums" => $orderNums,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Api\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Api\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}