<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookProductPassedByParams(array $params)
 * @method hookStreamStateChangedByParams(array $params)
 * @method hookStreamPassedByParams(array $params)
 * @method hookNegativeSeedByParams(array $params)
 * @method hookSecondRetouchUpdatePhotoByParams(array $params)
 * @method hookSecondRetouchPhotoConfirmedByParams(array $params)
 * @method hookSecondRetouchStreamSatisfiedByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hook 云端产品通过
     * todo 下个版本
     *
     * @support  int $id 云端产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookProductPassed () {
        return self::getClass()->hookProductPassed();
    }

    /**
     * hook 云端流水状态变更
     *
     * @support  string $stream_num 云端流水号 [ require true ]
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamStateChanged () {
        return self::getClass()->hookStreamStateChanged();
    }

    /**
     * hook 云端流水审核通过
     *
     * @support  string $stream_num 云端流水号 [ require true ]
     * @support  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamPassed () {
        return self::getClass()->hookStreamPassed();
    }

    /**
     * hook 底片消息通知已发送
     *
     * @support  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookNegativeSeed () {
        return self::getClass()->hookNegativeSeed();
    }

    /**
     * hook 看片师已更新照片
     *
     * @support  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchUpdatePhoto () {
        return self::getClass()->hookSecondRetouchUpdatePhoto();
    }

    /**
     * hook 顾客已反馈更新照片
     *
     * @support  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchPhotoConfirmed () {
        return self::getClass()->hookSecondRetouchPhotoConfirmed();
    }

    /**
     * hook 顾客流水已满意
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchStreamSatisfied () {
        return self::getClass()->hookSecondRetouchStreamSatisfied();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}