<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method addSkuByParams(array $params)
 * @method addProductSkuByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品注册/修改
     *
     * @support  int $name name [Original type uint] 
     * @support  int $cover_path cover_path [Original type uint] 
     * @support  int $cloud_product_id cloud_product_id [Original type uint] 
     * @support  int $description description [Original type uint] 
     * @support  int $information information [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct () {
        return self::getClass()->addProduct();
    }

    /**
     * sku注册/修改
     *
     * @support  int $id id [Original type uint] 
     * @support  int $name name [Original type uint] 
     * @throws  \Exception
     * @return  string
     */
    public static function addSku () {
        return self::getClass()->addSku();
    }

    /**
     * 产品sku注册/修改
     *
     * @support  int $id id [Original type uint] 
     * @support  int $productId productId [Original type uint] 
     * @support  int $skuId skuId [Original type uint] 
     * @support  int $price price [Original type uint] 
     * @support  int $priceExtend priceExtend [Original type uint] 
     * @throws  \Exception
     * @return  string
     */
    public static function addProductSku () {
        return self::getClass()->addProductSku();
    }

    /**
     * 手动初始化当日随机数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}