<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method wxLoginByParams(array $params)
 * @method loginByParams(array $params)
 * @method signUpByParams(array $params)
 * @method logoutByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 小程序登录
     *
     * @param  string $code code [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function wxLogin (string $code) {
        return self::getClass()->wxLogin([
            "code" => $code,
        ]);
    }

    /**
     * 授权手机号登录
     *
     * @param  string $encryptedData encryptedData [ require true ]
     * @param  string $iv iv [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function login (string $encryptedData, string $iv) {
        return self::getClass()->login([
            "encryptedData" => $encryptedData,
            "iv" => $iv,
        ]);
    }

    /**
     * 手机＋验证码登录
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function signUp (string $phone, string $code) {
        return self::getClass()->signUp([
            "phone" => $phone,
            "code" => $code,
        ]);
    }

    /**
     * 退出登陆
     *
     * @throws  \Exception
     * @return  string
     */
    public static function logout () {
        return self::getClass()->logout();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}