<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookProductPassedByParams(array $params)
 * @method hookStreamPassedByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hook 云端产品通过
     * todo RpcMessageHook
     *
     * @support  int $id 云端产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookProductPassed () {
        return self::getClass()->hookProductPassed();
    }

    /**
     * hook 云端流水审核通过
     * todo RpcMessageHook
     *
     * @support  string $streamNum 云端流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamPassed () {
        return self::getClass()->hookStreamPassed();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}