<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitByParams(array $params)
 * @method getListByParams(array $params)
 * @method cancelByParams(array $params)
 * @method detailByParams(array $params)
 * @method confirmByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交订单
     *
     * @support  int $productSkuId 产品-规格－id [Original type uint] [ require true ]
     * @support  float $price 价格 [Original type double] [ require true ]
     * @support  array $photoData 照片数据 [ require true ]
     * @support  array $require 照片要求 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function submit () {
        return self::getClass()->submit();
    }

    /**
     * 我的订单列表
     *
     * @param  string $state 订单状态 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (string $state = NULL, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getList([
            "state" => $state,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id) {
        return self::getClass()->cancel([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单确认
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm (int $id) {
        return self::getClass()->confirm([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}