<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method addSkuByParams(array $params)
 * @method addProductSkuByParams(array $params)
 * @method addRequireSetByParams(array $params)
 * @method addproductSkuRequireSetByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 * @method paidOrderByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [Original type uint] 
     * @support  string $name name 
     * @support  string $coverPath cover_path 
     * @support  string $thumbnailPath thumbnailPath 
     * @support  string $sharePath sharePath 
     * @support  string $description description 
     * @support  string $information information 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct () {
        return self::getClass()->addProduct();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [Original type uint] 
     * @support  string $name name 
     * @support  string $description description 
     * @throws  \Exception
     * @return  string
     */
    public static function addSku () {
        return self::getClass()->addSku();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [Original type uint] 
     * @support  int $productId productId [Original type uint] 
     * @support  int $skuId skuId [Original type uint] 
     * @support  int $cloudProductId cloud_product_id [Original type uint] 
     * @support  float $price price [Original type double] 
     * @support  array $priceExtend priceExtend 
     * @throws  \Exception
     * @return  string
     */
    public static function addProductSku () {
        return self::getClass()->addProductSku();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [Original type uint] 
     * @support  string $name name 
     * @support  array $sets 配置数组 
     * @throws  \Exception
     * @return  string
     */
    public static function addRequireSet () {
        return self::getClass()->addRequireSet();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [Original type uint] 
     * @support  int $productSkuId productSkuId [Original type uint] [ require true ]
     * @support  int $productRequireSetId 产品要求set id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function addproductSkuRequireSet () {
        return self::getClass()->addproductSkuRequireSet();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @throws  \Exception
     * @return  array
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paidOrder () {
        return self::getClass()->paidOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}