<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method wxLoginByParams(array $params)
 * @method loginByParams(array $params)
 * @method loginByPhoneWithCaptionByParams(array $params)
 * @method logoutByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 微信登录
     *
     * @support  string $code 微信code [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function wxLogin () {
        return self::getClass()->wxLogin();
    }

    /**
     * 授权手机号登录
     *
     * @support  string $mobileEncrypt 手机加密值 [ require true ]
     * @support  string $mobileIv 手机iv [ require true ]
     * @support  string $tempToken 微信code [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function login () {
        return self::getClass()->login();
    }

    /**
     * 手机＋验证码登录
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  string $caption 验证码 [ require true ]
     * @support  string $tempToken 微信tempToken [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function loginByPhoneWithCaption () {
        return self::getClass()->loginByPhoneWithCaption();
    }

    /**
     * 退出登陆
     *
     * @support  string $tempToken tempToken [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function logout () {
        return self::getClass()->logout();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}