<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initRandomSequenceByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method confirmOrderByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成第二日随机码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 订单超15分钟未支付自动关闭
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder();
    }

    /**
     * 订单超15天自动确认
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmOrder () {
        return self::getClass()->confirmOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}