<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-12 09:41:52
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RefundDamages
 * @method createByParams(array $params) 创建赔偿退款
 * @method getListWithPaginatorByParams(array $params) 赔偿退款列表-分页
 * @method refundDamagesDetailByParams(array $params) 赔偿退款详情
 * @method finishRefundDamagesByParams(array $params) 标记退款已处理
 */
class RefundDamages {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "RetailOrder\\RefundDamages";

    /**
     * 创建赔偿退款
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Cmd\CreateRefundDamagesCmd $createRefundDamagesCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createRefundDamagesCmd);
    }

    /**
     * 赔偿退款列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\DTO\RefundDamagesListWithPaginatorDto
    */
    public static function getListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Cmd\GetRefundDamagesListWithPaginatorCmd $getRefundDamagesListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getListWithPaginator($getRefundDamagesListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\DTO\RefundDamagesListWithPaginatorDto"
        );
    }

    /**
     * 赔偿退款详情
     * @return  \Mainto\Bridge\Structs\ProjectRetail\DTO\RefundDamagesDTO
    */
    public static function refundDamagesDetail (\Mainto\Bridge\Structs\ProjectRetail\Cmd\RefundDamagesIdCmd $refundDamagesIdCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->refundDamagesDetail($refundDamagesIdCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\DTO\RefundDamagesDTO"
        );
    }

    /**
     * 标记退款已处理
     * @return  bool
    */
    public static function finishRefundDamages (\Mainto\Bridge\Structs\ProjectRetail\Cmd\FinishDamagesCmd $finishDamagesCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishRefundDamages($finishDamagesCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}