<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-12 09:41:52
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Project;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProjectCollect
 * @method getStateByParams(array $params) 门店收集状态
 * @method saveByParams(array $params) 门店填写收集
 * @method historyByParams(array $params) 门店历史信息收集
 * @method getSkuListByParams(array $params) 计划包含的SKU
 */
class ProjectCollect {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Project\\ProjectCollect";

    /**
     * 门店收集状态
     * @return  array
    */
    public static function getState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getState();
    }

    /**
     * 门店填写收集
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function save (int $project_id, array $sku_info) {
        return RpcClass::getClass(self::$serviceName, self::$className)->save(["project_id" => $project_id, "sku_info" => $sku_info]);
    }

    /**
     * 门店历史信息收集
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function history (int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->history(["pageSize" => $pageSize]);
    }

    /**
     * 计划包含的SKU
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkuList (int $project_id, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuList(["project_id" => $project_id, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}