<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-12 09:41:52
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method listByParams(array $params) 产品分页列表
 * @method getSkusByProductByParams(array $params) 根据商品id获取对应的sku信息
 * @method getExpressUrgentListByParams(array $params) 获取物流和加急服务数据
 * @method flashSellChannelProductAndSkuBySkuCodeByParams(array $params) 根据skuCode刷入渠道sku数据
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Product\\Product";

    /**
     * 产品分页列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $isCombine = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["isCombine" => $isCombine]);
    }

    /**
     * 根据商品id获取对应的sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkusByProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByProduct(["id" => $id]);
    }

    /**
     * 获取物流和加急服务数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getExpressUrgentList (string $provinceName, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExpressUrgentList(["provinceName" => $provinceName, "detail" => $detail]);
    }

    /**
     * 根据skuCode刷入渠道sku数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function flashSellChannelProductAndSkuBySkuCode (array $skuCodes, int $sellChannelId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->flashSellChannelProductAndSkuBySkuCode(["skuCodes" => $skuCodes, "sellChannelId" => $sellChannelId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}