<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-12 09:41:52
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method createByParams(array $params) 创建零售商城订单或者门店定制订单
 * @method getOrderLogicParamsByParams(array $params) 门店定制获取小程序下单逻辑参数数据
 * @method detailItemScatteredByParams(array $params) 订单详情主表和子表不聚合
 * @method detailItemAssociativeByParams(array $params) 订单详情主表和子表聚合
 * @method listByParams(array $params) 订单列表
 * @method closeByUserByParams(array $params) 用户手动关闭订单——未支付状态
 * @method receivedByUserByParams(array $params) 用户订单——手动收货
 * @method orderLogisticsByParams(array $params) 订单物流信息
 * @method orderStatusConfirmingByParams(array $params) 设置订单状态是支付确认中
 * @method addOrderAddressByParams(array $params) 根据订单id保存用户邮寄地址
 * @method setPaidByParams(array $params) 设置订单完成支付-不走支付网关
 */
class Order {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\Order";

    /**
     * 创建零售商城订单或者门店定制订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create (float $money, float $originalMoney, float $realMoney, array $detail, string $from = 'mall', string $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["money" => $money, "originalMoney" => $originalMoney, "realMoney" => $realMoney, "detail" => $detail, "from" => $from, "source" => $source]);
    }

    /**
     * 门店定制获取小程序下单逻辑参数数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderLogicParams (int $staffId, array $compositionDraftIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderLogicParams(["staffId" => $staffId, "compositionDraftIds" => $compositionDraftIds]),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\GetOrderLogicParamsDTO[]"
        );
    }

    /**
     * 订单详情主表和子表不聚合
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailItemScattered (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemScattered(["id" => $id]);
    }

    /**
     * 订单详情主表和子表聚合
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailItemAssociative (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemAssociative(["id" => $id]);
    }

    /**
     * 订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list (int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 用户手动关闭订单——未支付状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeByUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByUser(["id" => $id]);
    }

    /**
     * 用户订单——手动收货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function receivedByUser (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receivedByUser(["id" => $id]);
    }

    /**
     * 订单物流信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function orderLogistics (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogistics(["orderId" => $orderId]);
    }

    /**
     * 设置订单状态是支付确认中
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderStatusConfirming (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderStatusConfirming(["id" => $id]);
    }

    /**
     * 根据订单id保存用户邮寄地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addOrderAddress (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress(["orderId" => $orderId]);
    }

    /**
     * 设置订单完成支付-不走支付网关
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setPaid (int $id, float $money, string $payType, string $paymentNo = '', string $certificate = '', string $paymentTime = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "money" => $money, "payType" => $payType, "paymentNo" => $paymentNo, "certificate" => $certificate, "paymentTime" => $paymentTime]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}