<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-12 09:41:52
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SellChannel
 * @method createByParams(array $params) 创建渠道
 * @method listByParams(array $params) 渠道列表
 * @method copyProductSkuByParams(array $params) 复制渠道商品sku
 * @method updateProductSkuByParams(array $params) 修改渠道商品sku
 * @method shelveProductSkuByParams(array $params) 批量销售渠道上架productSku
 * @method unshelveProductSkuByParams(array $params) 批量销售渠道下架productSku
 * @method productSkuListWithoutPaginateByParams(array $params) 销售渠道productSku列表 - 分页
 * @method productSkuListByParams(array $params) 销售渠道productSku列表 - 不分页
 * @method productListWithoutPaginateByParams(array $params) 销售渠道product列表 - 分页
 * @method productListByParams(array $params) 产品搜索查询-不分页
 * @method updateProductByParams(array $params) 销售渠道product更新
 * @method shelveProductByParams(array $params) 批量销售渠道上架product
 * @method unShelveProductByParams(array $params) 批量销售渠道下架product
 * @method getProductByIdByParams(array $params) 根据产品id获取单个product
 * @method manualBatchUpdateSkuByParams(array $params) 手动批量更新sku信息
 * @method batchUpdateProductSkuSellPriceByParams(array $params) 批量设置productSku的sellPrice
 * @method exportAddByParams(array $params) 导出某个渠道所有的sku简略信息
 * @method batchUpdateGiftProductSkuByParams(array $params) 批量设置赠品Sku
 * @method getSkuIdsBySellChannelIdByParams(array $params) 获取某渠道下所有的skuIds-不分页
 * @method batchUpdateSkuImageBySkuIdsByParams(array $params) 批量更新渠道sku图片
 */
class SellChannel {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\SellChannel";

    /**
     * 创建渠道
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name]);
    }

    /**
     * 渠道列表
     * @return  array
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list();
    }

    /**
     * 复制渠道商品sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function copyProductSku (int $sellChannelProductSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyProductSku(["sellChannelProductSkuId" => $sellChannelProductSkuId]);
    }

    /**
     * 修改渠道商品sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateProductSku (int $sellChannelProductSkuId, string $sellChannelCode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductSku(["sellChannelProductSkuId" => $sellChannelProductSkuId, "sellChannelCode" => $sellChannelCode]);
    }

    /**
     * 批量销售渠道上架productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function shelveProductSku (array $sellChannelProductSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->shelveProductSku(["sellChannelProductSkuIds" => $sellChannelProductSkuIds]);
    }

    /**
     * 批量销售渠道下架productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function unshelveProductSku (array $sellChannelProductSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unshelveProductSku(["sellChannelProductSkuIds" => $sellChannelProductSkuIds]);
    }

    /**
     * 销售渠道productSku列表 - 分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuListWithoutPaginate (int $sellChannelId, bool $isOnlyShelveUp = false, int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithoutPaginate(["sellChannelId" => $sellChannelId, "isOnlyShelveUp" => $isOnlyShelveUp, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 销售渠道productSku列表 - 不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuList (int $sellChannelId, bool $isOnlyShelveUp = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["sellChannelId" => $sellChannelId, "isOnlyShelveUp" => $isOnlyShelveUp]);
    }

    /**
     * 销售渠道product列表 - 分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productListWithoutPaginate (int $sellChannelId = 5, int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWithoutPaginate(["sellChannelId" => $sellChannelId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 产品搜索查询-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productList (int $type = 4, int $sellChannelId = 5, bool $isOnlyShelveUp = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productList(["type" => $type, "sellChannelId" => $sellChannelId, "isOnlyShelveUp" => $isOnlyShelveUp]);
    }

    /**
     * 销售渠道product更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateProduct (int $sellChannelProductId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProduct(["sellChannelProductId" => $sellChannelProductId]);
    }

    /**
     * 批量销售渠道上架product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function shelveProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->shelveProduct([]);
    }

    /**
     * 批量销售渠道下架product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function unShelveProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->unShelveProduct([]);
    }

    /**
     * 根据产品id获取单个product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id]);
    }

    /**
     * 手动批量更新sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function manualBatchUpdateSku (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualBatchUpdateSku(["data" => $data]);
    }

    /**
     * 批量设置productSku的sellPrice
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchUpdateProductSkuSellPrice (array $productSkus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateProductSkuSellPrice(["productSkus" => $productSkus]);
    }

    /**
     * 导出某个渠道所有的sku简略信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportAdd(["template_id" => $template_id]);
    }

    /**
     * 批量设置赠品Sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchUpdateGiftProductSku (array $skuIds, string $startTime, string $endTime, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateGiftProductSku(["skuIds" => $skuIds, "startTime" => $startTime, "endTime" => $endTime, "storeIds" => $storeIds]);
    }

    /**
     * 获取某渠道下所有的skuIds-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuIdsBySellChannelId (int $sellChannelId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIdsBySellChannelId(["sellChannelId" => $sellChannelId]);
    }

    /**
     * 批量更新渠道sku图片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchUpdateSkuImageBySkuIds (array $updateProductSkuImages) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuImageBySkuIds(["updateProductSkuImages" => $updateProductSkuImages]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}