<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-12 09:41:52
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Coupon
 * @method getCouponCreateLogsByParams(array $params) 获取优惠券创建列表
 * @method getTemplateListByParams(array $params) 获取优惠券模版列表-分页
 * @method selectTemplatesByParams(array $params) 获取优惠券模版列表
 * @method abolishCouponsByParams(array $params) 作废优惠券
 * @method deleteSettingCouponByParams(array $params) 删除优惠券配置信息
 * @method getTemplateInfoByParams(array $params) 查看模版详情
 * @method getCouponsByParams(array $params) 查看优惠卷码详情
 * @method bulkGenerateCouponsByParams(array $params) 创建优惠卷
 * @method bindUserCouponsByParams(array $params) 创建绑定单个用户优惠卷
 * @method createTemplateByParams(array $params) 创建优惠券模版
 * @method templateUpdateByParams(array $params) 更新优惠券模版
 * @method getAllSkuByTypeByParams(array $params) 可用产品，所有零售商品列表
 * @method getSkuIdsByTypeByParams(array $params) 可用产品，所有零售商品列表
 * @method productSkuListByParams(array $params) 获取productSku-分页
 */
class Coupon {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Coupon";

    /**
     * 获取优惠券创建列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCouponCreateLogs (string $applyIn = 'retail', int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponCreateLogs(["applyIn" => $applyIn, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取优惠券模版列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTemplateList (string $applyIn = 'retail') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateList(["applyIn" => $applyIn]);
    }

    /**
     * 获取优惠券模版列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function selectTemplates (string $applyIn = 'retail') {
        return RpcClass::getClass(self::$serviceName, self::$className)->selectTemplates(["applyIn" => $applyIn]);
    }

    /**
     * 作废优惠券
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function abolishCoupons (array $ids, string $type = 'handle') {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCoupons(["ids" => $ids, "type" => $type]);
    }

    /**
     * 删除优惠券配置信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteSettingCoupon () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSettingCoupon([]);
    }

    /**
     * 查看模版详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTemplateInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateInfo(["id" => $id]);
    }

    /**
     * 查看优惠卷码详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCoupons (int $createLogId, string $applyIn = 'retail') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoupons(["createLogId" => $createLogId, "applyIn" => $applyIn]);
    }

    /**
     * 创建优惠卷
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function bulkGenerateCoupons (int $recordId, string $title, string $status, int $templateId, string $buyChannel, float $discount, string $applyScene, string $limit = 'compute', string $timeType = 'free') {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCoupons(["recordId" => $recordId, "title" => $title, "status" => $status, "templateId" => $templateId, "buyChannel" => $buyChannel, "discount" => $discount, "applyScene" => $applyScene, "limit" => $limit, "timeType" => $timeType]);
    }

    /**
     * 创建绑定单个用户优惠卷
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bindUserCoupons (int $count, int $recordId, string $title, string $status = 'unused', int $templateId, string $buyChannel = 'personal', float $discount, string $stopUsage, string $startUsage) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserCoupons(["count" => $count, "recordId" => $recordId, "title" => $title, "status" => $status, "templateId" => $templateId, "buyChannel" => $buyChannel, "discount" => $discount, "stopUsage" => $stopUsage, "startUsage" => $startUsage]);
    }

    /**
     * 创建优惠券模版
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function createTemplate (string $name, string $type, string $allSku = 'part', string $applyIn = 'retail', string $tagType = 'normal') {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTemplate(["name" => $name, "type" => $type, "allSku" => $allSku, "applyIn" => $applyIn, "tagType" => $tagType]);
    }

    /**
     * 更新优惠券模版
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function templateUpdate (int $id, string $name, string $type, string $applyIn = 'retail', string $tagType = 'normal') {
        return RpcClass::getClass(self::$serviceName, self::$className)->templateUpdate(["id" => $id, "name" => $name, "type" => $type, "applyIn" => $applyIn, "tagType" => $tagType]);
    }

    /**
     * 可用产品，所有零售商品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllSkuByType (int $type = 4) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSkuByType(["type" => $type]);
    }

    /**
     * 可用产品，所有零售商品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuIdsByType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIdsByType([]);
    }

    /**
     * 获取productSku-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuList (int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}