<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SkuCalc
 * @method bestSkuCaleByParams(array $params) 计算产品价格并返回计算详情
 * @method pointSkuCaleByParams(array $params) 指定参加活动和排序处理计算优惠信息
 * @method getDiscountListBySkuIdsByParams(array $params) 根据skuIds获取对应可参加的活动
 * @method getDiscountsByDiscountIdsByParams(array $params) 根据discountIds获取discounts,包含与之互斥的活动也带出来
 */
class SkuCalc {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Store\\Product\\SkuCalc";

    /**
     * 计算产品价格并返回计算详情
     * @return  array
    */
    public static function bestSkuCale (\Mainto\Bridge\Structs\ProjectRetail\Store\Cmd\SkuCale\BestSkuCalcCmd $bestSkuCalcCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bestSkuCale($bestSkuCalcCmd);
    }

    /**
     * 指定参加活动和排序处理计算优惠信息
     * @return  array
    */
    public static function pointSkuCale (\Mainto\Bridge\Structs\ProjectRetail\Store\Cmd\SkuCale\PointSkuCalcCmd $pointSkuCalcCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pointSkuCale($pointSkuCalcCmd);
    }

    /**
     * 根据skuIds获取对应可参加的活动
     * @return  array
    */
    public static function getDiscountListBySkuIds (\Mainto\Bridge\Structs\ProjectRetail\Store\Cmd\SkuCale\GetDiscountListCmd $getDiscountListCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDiscountListBySkuIds($getDiscountListCmd);
    }

    /**
     * 根据discountIds获取discounts,包含与之互斥的活动也带出来
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDiscountsByDiscountIds (array $discountIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDiscountsByDiscountIds(["discountIds" => $discountIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}