<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method productSkuListWithPaginateByParams(array $params) 零售POS收银-productSku列表
 * @method productSkuDetailByParams(array $params) 零售POS收银-productSku详情
 * @method getPromotionProductSkuByParams(array $params) 根据活动获取促销商品sku列表
 * @method getProductSkuBySkuCodeByParams(array $params) 根据skuCode扫码获取productSku
 * @method getStockBySkuIdsByParams(array $params) 根据门店id和skuIds获取对应的库存
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Store\\Product\\Product";

    /**
     * 零售POS收银-productSku列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuListWithPaginate (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithPaginate(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 零售POS收银-productSku详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuDetail (int $sellChannelProductSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDetail(["sellChannelProductSkuId" => $sellChannelProductSkuId]);
    }

    /**
     * 根据活动获取促销商品sku列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPromotionProductSku (int $promotionId, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPromotionProductSku(["promotionId" => $promotionId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 根据skuCode扫码获取productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductSkuBySkuCode (string $skuCode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuBySkuCode(["skuCode" => $skuCode]);
    }

    /**
     * 根据门店id和skuIds获取对应的库存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStockBySkuIds (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockBySkuIds(["skuIds" => $skuIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}