<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method createByParams(array $params) 创建订单
 * @method giftCardPrePayByParams(array $params) 使用礼品卡支付预付
 * @method giftCardPayInfoByParams(array $params) 根据订单id，查询用户是否使用了礼品卡，和礼品卡使用了多少
 * @method detailByParams(array $params) 订单详情
 * @method getOrderDetailByVerifyCodeByParams(array $params) 通过核销取件码，获取零售自提订单核销相关的信息
 * @method storeOrderListByParams(array $params) 门店零售订单列表
 * @method listPageByParams(array $params) 门店定制订单列表-分页
 * @method changePayTypeByParams(array $params) 修改流水支付方式
 */
class Order {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Store\\Order\\Order";

    /**
     * 创建订单
     * @return  mixed
    */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Cmd\CreateOrderCmd $createOrderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createOrderCmd);
    }

    /**
     * 使用礼品卡支付预付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function giftCardPrePay (int $id, float $giftCardMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPrePay(["id" => $id, "giftCardMoney" => $giftCardMoney]);
    }

    /**
     * 根据订单id，查询用户是否使用了礼品卡，和礼品卡使用了多少
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function giftCardPayInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPayInfo(["id" => $id]);
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 通过核销取件码，获取零售自提订单核销相关的信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderDetailByVerifyCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetailByVerifyCode(["code" => $code]);
    }

    /**
     * 门店零售订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function storeOrderList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeOrderList([]);
    }

    /**
     * 门店定制订单列表-分页
     * @return  mixed
    */
    public static function listPage (\Mainto\Bridge\Structs\ProjectRetail\Cmd\OrderListPageCmd $orderListPageCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPage($orderListPageCmd);
    }

    /**
     * 修改流水支付方式
     * @return  string
    */
    public static function changePayType (\Mainto\Bridge\Structs\ProjectRetail\Cmd\ChangePayTypeCmd $changePayTypeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType($changePayTypeCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}