<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ShopCart
 * @method createByParams(array $params) 创建购物车
 * @method updateByParams(array $params) 修改购物车
 * @method deleteByParams(array $params) 删除购物车
 * @method getListByParams(array $params) 展示购物车
 * @method getCountByParams(array $params) 获取购物车商品条数
 */
class ShopCart {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Order\\ShopCart";

    /**
     * 创建购物车
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CreateShopCartCmd $createShopCartCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createShopCartCmd);
    }

    /**
     * 修改购物车
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function update (array $products) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->update(["products" => $products]),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartSkuDTO[]"
        );
    }

    /**
     * 删除购物车
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["ids" => $ids]);
    }

    /**
     * 展示购物车
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartListDTO
    */
    public static function getList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getList(),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartListDTO"
        );
    }

    /**
     * 获取购物车商品条数
     * @return  array
    */
    public static function getCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCount();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}