<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class StoreGroup
 * @method setProductStoreGroupByParams(array $params) 设置零售商品售卖的门店或者门店组
 * @method getStoreGroupBySkuIdByParams(array $params) 获取商品门店组信息
 * @method clearStoreGroupBySkuIdByParams(array $params) 清空商品skuId与门店、门店组关系
 * @method deleteStoreGroupBySkuIdByParams(array $params) 删除商品与门店的关系
 * @method addProductSkuStoreGroupByParams(array $params) 新增商品与门店组/门店管理
 * @method createByParams(array $params) 创建门店组
 * @method updateByParams(array $params) 修改门店组
 * @method listByParams(array $params) 门店组列表-分页
 * @method listWithoutPaginateByParams(array $params) 门店组列表-不分页
 * @method deleteByParams(array $params) 删除门店组
 * @method allByParams(array $params) 获取全部门店组信息
 * @method storeListByParams(array $params) 门店搜索列表
 * @method getStoresByParams(array $params) 搜索所有门店-不分页
 * @method getStoreIdsByStoreGroupIdsByParams(array $params) 门店组详情-带有门店
 */
class StoreGroup {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\StoreGroup";

    /**
     * 设置零售商品售卖的门店或者门店组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductStoreGroup(["ids" => $ids, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds]);
    }

    /**
     * 获取商品门店组信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStoreGroupBySkuId (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreGroupBySkuId(["skuId" => $skuId]);
    }

    /**
     * 清空商品skuId与门店、门店组关系
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function clearStoreGroupBySkuId (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearStoreGroupBySkuId(["skuId" => $skuId]);
    }

    /**
     * 删除商品与门店的关系
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteStoreGroupBySkuId (int $skuId, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStoreGroupBySkuId(["skuId" => $skuId, "storeIds" => $storeIds]);
    }

    /**
     * 新增商品与门店组/门店管理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addProductSkuStoreGroup (int $skuId, array $storeGroupIds = [], array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductSkuStoreGroup(["skuId" => $skuId, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds]);
    }

    /**
     * 创建门店组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function create (string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "remark" => $remark, "rule" => $rule, "whitelist" => $whitelist, "blacklist" => $blacklist]);
    }

    /**
     * 修改门店组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (int $id, string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "remark" => $remark, "rule" => $rule, "whitelist" => $whitelist, "blacklist" => $blacklist]);
    }

    /**
     * 门店组列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 门店组列表-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listWithoutPaginate (string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithoutPaginate(["name" => $name]);
    }

    /**
     * 删除门店组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 获取全部门店组信息
     * @return  array
    */
    public static function all () {
        return RpcClass::getClass(self::$serviceName, self::$className)->all();
    }

    /**
     * 门店搜索列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storeList (int $page = 1, int $pageSize = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 搜索所有门店-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStores () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStores([]);
    }

    /**
     * 门店组详情-带有门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStoreIdsByStoreGroupIds (array $storeGroupIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsByStoreGroupIds(["storeGroupIds" => $storeGroupIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}