<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Discount
 * @method createByParams(array $params) 创建促销活动
 * @method updateByParams(array $params) 编辑促销活动
 * @method stopByParams(array $params) 终止促销活动
 * @method detailByParams(array $params) 促销活动详情
 * @method listWithPaginateByParams(array $params) 促销活动列表
 * @method listByParams(array $params) 促销活动列表
 * @method getNotStartAndInPorgressDiscountListByParams(array $params) 活动状态为：进行中、未开始的促销活动列表
 * @method createDiscountMutexByParams(array $params) 创建促销活动互斥关系
 * @method deleteDiscountMutexByParams(array $params) 删除促销活动互斥关系
 * @method discountMutexListByParams(array $params) 展示所有已添加互斥关系的活动，且活动状态为：进行中、未开始
 * @method checkProductSkuImportByParams(array $params) 校验创建条件单时批量导入的productSku数据合法性
 * @method exportAddByParams(array $params) 导出某个渠道所有的sku简略信息
 * @method getAdjustPriceProductSkuListByParams(array $params) 促销活动详情sku
 */
class Discount {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Discount";

    /**
     * 创建促销活动
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountCmd $createDiscountCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createDiscountCmd);
    }

    /**
     * 编辑促销活动
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountCmd $updateDiscountCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($updateDiscountCmd);
    }

    /**
     * 终止促销活动
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function stop (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stop(["id" => $id]);
    }

    /**
     * 促销活动详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 促销活动列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listWithPaginate (bool $incluedeDiscountRule = false, bool $incluedeDiscountMetaData = false, int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginate(["incluedeDiscountRule" => $incluedeDiscountRule, "incluedeDiscountMetaData" => $incluedeDiscountMetaData, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 促销活动列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (bool $incluedeDiscountRule = false, bool $incluedeDiscountMetaData = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["incluedeDiscountRule" => $incluedeDiscountRule, "incluedeDiscountMetaData" => $incluedeDiscountMetaData]);
    }

    /**
     * 活动状态为：进行中、未开始的促销活动列表
     * @return  array
    */
    public static function getNotStartAndInPorgressDiscountList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNotStartAndInPorgressDiscountList();
    }

    /**
     * 创建促销活动互斥关系
     * @return  array
    */
    public static function createDiscountMutex (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountMutexCmd $createDiscountMutexCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDiscountMutex($createDiscountMutexCmd);
    }

    /**
     * 删除促销活动互斥关系
     * @return  bool
    */
    public static function deleteDiscountMutex () {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteDiscountMutex();
    }

    /**
     * 展示所有已添加互斥关系的活动，且活动状态为：进行中、未开始
     * @return  array
    */
    public static function discountMutexList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->discountMutexList();
    }

    /**
     * 校验创建条件单时批量导入的productSku数据合法性
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function checkProductSkuImport (array $productSkus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductSkuImport(["productSkus" => $productSkus]);
    }

    /**
     * 导出某个渠道所有的sku简略信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function exportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportAdd(["template_id" => $template_id]);
    }

    /**
     * 促销活动详情sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAdjustPriceProductSkuList (int $storeId, string $checkTime, array $ids, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdjustPriceProductSkuList(["storeId" => $storeId, "checkTime" => $checkTime, "ids" => $ids, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}