<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:11:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CustomizedComponent
 * @method createByParams(array $params) 创建模版组
 * @method updateByParams(array $params) 更新模版组
 * @method detailByParams(array $params) 模版组详情
 * @method deleteByParams(array $params) 删除模版组
 * @method listWithPaginateByParams(array $params) 模版组列表-分页
 * @method listByParams(array $params) 模版组列表-不分页
 * @method createComponentItemByParams(array $params) 创建模版组类目
 * @method updateComponentItemByParams(array $params) 更新模版组类目
 * @method deleteComponentItemByParams(array $params) 删除模版组类目
 * @method componentItemListByParams(array $params) 模版组类目列表
 * @method componentBindItemsByParams(array $params) 绑定模版组贴图
 * @method componentItemListWithPaginateByParams(array $params) 模版组类目列表-分页
 * @method getComponentsBindItemListByParams(array $params) 绑定贴图列表
 * @method skuBindComponentsByParams(array $params) sku绑定模版
 * @method getComponentsBindSkuListByParams(array $params) sku绑定模版列表
 */
class CustomizedComponent {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Customized\\CustomizedComponent";

    /**
     * 创建模版组
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO
    */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentCmd $createComponentCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($createComponentCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO"
        );
    }

    /**
     * 更新模版组
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentCmd $updateComponentCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($updateComponentCmd);
    }

    /**
     * 模版组详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO"
        );
    }

    /**
     * 删除模版组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 模版组列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentListWithPaginateDTO
    */
    public static function listWithPaginate (?\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListWithPaginateCmd $componentListWithPaginateCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginate($componentListWithPaginateCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentListWithPaginateDTO"
        );
    }

    /**
     * 模版组列表-不分页
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListCmd $componentListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($componentListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO[]"
        );
    }

    /**
     * 创建模版组类目
     * @return  bool
    */
    public static function createComponentItem (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentItemCmd $createComponentItemCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createComponentItem($createComponentItemCmd);
    }

    /**
     * 更新模版组类目
     * @return  bool
    */
    public static function updateComponentItem (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentItemCmd $updateComponentItemCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateComponentItem($updateComponentItemCmd);
    }

    /**
     * 删除模版组类目
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteComponentItem (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteComponentItem(["id" => $id]);
    }

    /**
     * 模版组类目列表
     * @return  array
    */
    public static function componentItemList (?\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListCmd $componentItemListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->componentItemList($componentItemListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemDTO[]"
        );
    }

    /**
     * 绑定模版组贴图
     * @return  bool
    */
    public static function componentBindItems (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindItemsCmd $componentBindItemsCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->componentBindItems($componentBindItemsCmd);
    }

    /**
     * 模版组类目列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemListWithPaginateDTO
    */
    public static function componentItemListWithPaginate (?\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->componentItemListWithPaginate($componentItemListWithPaginateCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemListWithPaginateDTO"
        );
    }

    /**
     * 绑定贴图列表
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentBindItemListDTO
    */
    public static function getComponentsBindItemList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindItemListCmd $componentBindItemListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getComponentsBindItemList($componentBindItemListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentBindItemListDTO"
        );
    }

    /**
     * sku绑定模版
     * @return  bool
    */
    public static function skuBindComponents (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindSkuCmd $componentBindSkuCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuBindComponents($componentBindSkuCmd);
    }

    /**
     * sku绑定模版列表
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\SkuBindComponentListDTO
    */
    public static function getComponentsBindSkuList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindSkuListCmd $componentBindSkuListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getComponentsBindSkuList($componentBindSkuListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\SkuBindComponentListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}