<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:10:16
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Pay;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Pay
 * @method createByParams(array $params) 定制小程序-创建支付单
 * @method callbackByParams(array $params) 支付回调
 * @method zeroSetPaidByParams(array $params) 门店定制0元设置支付成功
 * @method callbackCashByParams(array $params) 支付回调，仅用于release，dev，pre环境调试使用，支付方式:现金
 * @method closeByParams(array $params) 关闭支付订单
 * @method getPayShortLinkByParams(array $params) 获取支付短链
 */
class Pay {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Pay\\Pay";

    /**
     * 定制小程序-创建支付单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create (string $orderNum, float $payMoney, string $openId, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderNum" => $orderNum, "payMoney" => $payMoney, "openId" => $openId, "extend" => $extend]);
    }

    /**
     * 支付回调
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function callback (string $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callback(["data" => $data]);
    }

    /**
     * 门店定制0元设置支付成功
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function zeroSetPaid (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->zeroSetPaid(["id" => $id]);
    }

    /**
     * 支付回调，仅用于release，dev，pre环境调试使用，支付方式:现金
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function callbackCash (int $id, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackCash(["id" => $id, "money" => $money]);
    }

    /**
     * 关闭支付订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function close (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["orderNum" => $orderNum]);
    }

    /**
     * 获取支付短链
     * @return  string
    */
    public static function getPayShortLink (\Mainto\Bridge\Structs\ProjectRetail\Cmd\GetPayLinkCmd $getPayLinkCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayShortLink($getPayLinkCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}