<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:10:16
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class User
 * @method userAddressesByParams(array $params) 用户收货地址查询
 * @method userAddressCreateByParams(array $params) 用户收货地址创建
 * @method userAddressUpdateByParams(array $params) 用户收货地址更新
 * @method userAddressDeleteByParams(array $params) 用户收货地址删除
 * @method addressTreeByParams(array $params) 获取省市区三级数据
 * @method detailByParams(array $params) 用户详情
 * @method forgetUserPasswordByParams(array $params) 通过手机号和短信验证码验证重置密码
 * @method bindStaffIdByParams(array $params) 用户id通过分销功能绑定员工id
 * @method createWxMiniCodeByParams(array $params) 通过员工token信息获取小程序二维码base64字符串
 * @method createWxQrCodeByParams(array $params) 创建通用二维码
 * @method userImageAndCompositionByParams(array $params) 用户中心图片和作品展示
 * @method userArrangeDataByParams(array $params) 用户中心统计订单、优惠券、图片、作品个数
 * @method getUserIdsByStaffIdByParams(array $params) 通过员工token信息获取绑定用户id列表
 * @method getStaffOrdersByParams(array $params) 通过员工token信息获取销售业绩列表
 * @method getUserInfoByParams(array $params) 根据手机号获取用户信息
 */
class User {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\User";

    /**
     * 用户收货地址查询
     * @return  array
    */
    public static function userAddresses () {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddresses();
    }

    /**
     * 用户收货地址创建
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function userAddressCreate (string $name, string $phone, int $cityId, int $provinceId, int $districtId, string $addressDetail, bool $isDefaultAddress = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddressCreate(["name" => $name, "phone" => $phone, "cityId" => $cityId, "provinceId" => $provinceId, "districtId" => $districtId, "addressDetail" => $addressDetail, "isDefaultAddress" => $isDefaultAddress]);
    }

    /**
     * 用户收货地址更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function userAddressUpdate (int $id, string $name, string $phone, int $cityId, int $provinceId, int $districtId, string $addressDetail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddressUpdate(["id" => $id, "name" => $name, "phone" => $phone, "cityId" => $cityId, "provinceId" => $provinceId, "districtId" => $districtId, "addressDetail" => $addressDetail]);
    }

    /**
     * 用户收货地址删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function userAddressDelete (int $userAddressId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddressDelete(["userAddressId" => $userAddressId]);
    }

    /**
     * 获取省市区三级数据
     * @return  array
    */
    public static function addressTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->addressTree();
    }

    /**
     * 用户详情
     * @return  mixed
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail();
    }

    /**
     * 通过手机号和短信验证码验证重置密码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "password" => $password, "captcha" => $captcha]);
    }

    /**
     * 用户id通过分销功能绑定员工id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bindStaffId (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindStaffId(["staffId" => $staffId]);
    }

    /**
     * 通过员工token信息获取小程序二维码base64字符串
     * @return  string
    */
    public static function createWxMiniCode () {
        return RpcClass::getClass(self::$serviceName, self::$className)->createWxMiniCode();
    }

    /**
     * 创建通用二维码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function createWxQrCode (string $scene, array $optional) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createWxQrCode(["scene" => $scene, "optional" => $optional]);
    }

    /**
     * 用户中心图片和作品展示
     * @return  array
    */
    public static function userImageAndComposition () {
        return RpcClass::getClass(self::$serviceName, self::$className)->userImageAndComposition();
    }

    /**
     * 用户中心统计订单、优惠券、图片、作品个数
     * @return  array
    */
    public static function userArrangeData () {
        return RpcClass::getClass(self::$serviceName, self::$className)->userArrangeData();
    }

    /**
     * 通过员工token信息获取绑定用户id列表
     * @return  array
    */
    public static function getUserIdsByStaffId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserIdsByStaffId();
    }

    /**
     * 通过员工token信息获取销售业绩列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStaffOrders () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffOrders([]);
    }

    /**
     * 根据手机号获取用户信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserInfo (string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfo(["phone" => $phone]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}