<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:10:16
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductSell
 * @method listByParams(array $params) 产品列表
 * @method productListWithPaginateByParams(array $params) 产品列表-分页
 * @method onlyProductListByParams(array $params) 获取渠道product，不包含sku信息列表
 * @method productListWeekSelectionByParams(array $params) 每周精选热门产品列表-分页
 * @method detailWithSkuByParams(array $params) 根据产品id获取产品和sku
 * @method getProductByIdByParams(array $params) 根据产品id获取单个product
 * @method getProductSkuByProductIdByParams(array $params) 根据产品id获取该产品所有的sku
 * @method searchProductListWithPaginateByParams(array $params) 搜索product列表 - 分页
 * @method searchKeywordsListByParams(array $params) 搜索热词列表
 * @method storeSkuAndTemplateDetailByParams(array $params) 获取门店sku商品详情[暂不支持获取书册模版]
 * @method storeSkuListByGroupByParams(array $params) 按照分组类型获取sku列表
 */
class ProductSell {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\ProductSell";

    /**
     * 产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (bool $isOnlyShelveUp = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["isOnlyShelveUp" => $isOnlyShelveUp]);
    }

    /**
     * 产品列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productListWithPaginate (int $sellChannelId = 5, string $status = 'shelve') {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWithPaginate(["sellChannelId" => $sellChannelId, "status" => $status]);
    }

    /**
     * 获取渠道product，不包含sku信息列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function onlyProductList (int $sellChannelId = 5, string $status = 'shelve') {
        return RpcClass::getClass(self::$serviceName, self::$className)->onlyProductList(["sellChannelId" => $sellChannelId, "status" => $status]);
    }

    /**
     * 每周精选热门产品列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productListWeekSelection (int $sellChannelId = 5, string $status = 'shelve') {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWeekSelection(["sellChannelId" => $sellChannelId, "status" => $status]);
    }

    /**
     * 根据产品id获取产品和sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailWithSku (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithSku(["id" => $id]);
    }

    /**
     * 根据产品id获取单个product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id]);
    }

    /**
     * 根据产品id获取该产品所有的sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductSkuByProductId (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuByProductId(["productId" => $productId]);
    }

    /**
     * 搜索product列表 - 分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchProductListWithPaginate (string $productName, int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProductListWithPaginate(["productName" => $productName, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 搜索热词列表
     * @return  array
    */
    public static function searchKeywordsList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchKeywordsList();
    }

    /**
     * 获取门店sku商品详情[暂不支持获取书册模版]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\storeSkuAndTemplateDetailDTO
    */
    public static function storeSkuAndTemplateDetail (int $skuId, int $orderId = 0, int $orderItemId = 0) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeSkuAndTemplateDetail(["skuId" => $skuId, "orderId" => $orderId, "orderItemId" => $orderItemId]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\storeSkuAndTemplateDetailDTO"
        );
    }

    /**
     * 按照分组类型获取sku列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storeSkuListByGroup (string $showPlace = 'store_product_list') {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeSkuListByGroup(["showPlace" => $showPlace]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}