<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:10:16
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method listByParams(array $params) 商品spu列表
 * @method detailWithSkuByParams(array $params) 根据产品id获取产品和sku
 * @method getProductByIdByParams(array $params) 根据产品id获取单个product
 * @method getProductSkuByProductIdByParams(array $params) 根据产品id获取该产品所有的sku
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\Product";

    /**
     * 商品spu列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 根据产品id获取产品和sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailWithSku (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithSku(["id" => $id]);
    }

    /**
     * 根据产品id获取单个product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id]);
    }

    /**
     * 根据产品id获取该产品所有的sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductSkuByProductId (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuByProductId(["productId" => $productId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}