<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:10:16
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Coupon
 * @method getUserCouponsByParams(array $params) 用户中心获取用户优惠券
 * @method bindCouponCodeByParams(array $params) 用户绑定优惠券
 * @method bindUserCouponsByParams(array $params) 根据不同场景绑定用户优惠卷
 * @method getCouponBySceneByParams(array $params) 根据应用场景获取零售优惠券展示信息
 * @method getSkuEffectiveCouponsByParams(array $params) 获取Sku有效优惠券
 * @method getCouponsListByIdsByParams(array $params) 根据创建ids获取优惠券列表
 * @method phoneBindCouponByParams(array $params) 根据手机号批量绑定指定优惠券
 * @method autoPhoneBindCouponByParams(array $params) 根据手机号批量绑定指定优惠券
 */
class Coupon {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\Coupon";

    /**
     * 用户中心获取用户优惠券
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserCoupons (array $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["status" => $status]);
    }

    /**
     * 用户绑定优惠券
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bindCouponCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindCouponCode(["code" => $code]);
    }

    /**
     * 根据不同场景绑定用户优惠卷
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function bindUserCoupons (string $applyScene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserCoupons(["applyScene" => $applyScene]);
    }

    /**
     * 根据应用场景获取零售优惠券展示信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCouponByScene (string $applyScene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponByScene(["applyScene" => $applyScene]);
    }

    /**
     * 获取Sku有效优惠券
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuEffectiveCoupons (array $products) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuEffectiveCoupons(["products" => $products]);
    }

    /**
     * 根据创建ids获取优惠券列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCouponsListByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponsListByIds(["ids" => $ids]);
    }

    /**
     * 根据手机号批量绑定指定优惠券
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function phoneBindCoupon () {
        return RpcClass::getClass(self::$serviceName, self::$className)->phoneBindCoupon([]);
    }

    /**
     * 根据手机号批量绑定指定优惠券
     * @return  bool
    */
    public static function autoPhoneBindCoupon () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoPhoneBindCoupon();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}