<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:10:16
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method modifyOrderStaffIdByOrderNoByParams(array $params) 根据订单编号修改售出伙伴id
 * @method detailItemScatteredByParams(array $params) 商城订单-订单详情主表和子表不聚合
 * @method storeDetailItemsByParams(array $params) 门店商城订单-订单详情
 * @method detailItemAssociativeByParams(array $params) 商城订单-订单详情主表和子表聚合
 * @method listByParams(array $params) 订单列表
 * @method storeListByParams(array $params) 订单列表
 * @method timingReceivedOrderByParams(array $params) 后台手动收货
 * @method orderListExportAddByParams(array $params) 订单列表导出
 * @method detailByParams(array $params) 零售订单详情
 * @method manualCreateProductOrderByParams(array $params) 手动创建生成单
 * @method manualChangeOrderStatusByParams(array $params) 零售订单详情
 * @method getOmsExceptionOrderListByParams(array $params) oms异常单列表
 * @method changePayTypeByParams(array $params) 修改订单支付方式
 * @method addOrderAddressByParams(array $params) 根据订单id保存用户邮寄地址
 * @method finishExpressByParams(array $params) 完成自提
 * @method setPaidByParams(array $params) 设置订单完成支付
 * @method dingNotifyStaffEffectByParams(array $params) 发送零售业绩钉钉消息)
 */
class Order {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Order\\Order";

    /**
     * 根据订单编号修改售出伙伴id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function modifyOrderStaffIdByOrderNo (string $orderNo, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyOrderStaffIdByOrderNo(["orderNo" => $orderNo, "inputStaffId" => $inputStaffId]);
    }

    /**
     * 商城订单-订单详情主表和子表不聚合
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailItemScattered (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemScattered(["id" => $id]);
    }

    /**
     * 门店商城订单-订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storeDetailItems (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeDetailItems(["id" => $id]);
    }

    /**
     * 商城订单-订单详情主表和子表聚合
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailItemAssociative (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemAssociative(["id" => $id]);
    }

    /**
     * 订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storeList (int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 后台手动收货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function timingReceivedOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->timingReceivedOrder(["id" => $id]);
    }

    /**
     * 订单列表导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function orderListExportAdd (string $template_id = 'retail_orders_list_template') {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderListExportAdd(["template_id" => $template_id]);
    }

    /**
     * 零售订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 手动创建生成单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function manualCreateProductOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualCreateProductOrder(["id" => $id]);
    }

    /**
     * 零售订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function manualChangeOrderStatus (string $status, int $orderId, int $orderItemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualChangeOrderStatus(["status" => $status, "orderId" => $orderId, "orderItemId" => $orderItemId]);
    }

    /**
     * oms异常单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOmsExceptionOrderList (int $page = 1, int $pageSize = 50) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOmsExceptionOrderList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 修改订单支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changePayType (int $id, string $payType, string $paymentNo = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payType" => $payType, "paymentNo" => $paymentNo]);
    }

    /**
     * 根据订单id保存用户邮寄地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addOrderAddress (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress(["orderId" => $orderId]);
    }

    /**
     * 完成自提
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function finishExpress () {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishExpress([]);
    }

    /**
     * 设置订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setPaid (int $id, float $money, string $pay_type, string $payment_no = '', string $certificate = '', string $payment_time = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "money" => $money, "pay_type" => $pay_type, "payment_no" => $payment_no, "certificate" => $certificate, "payment_time" => $payment_time]);
    }

    /**
     * 发送零售业绩钉钉消息)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function dingNotifyStaffEffect (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dingNotifyStaffEffect(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}