<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-25 09:33:21
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class AfterSale
 * @method getAfterSaleItemsByOrderIdByParams(array $params) 根据订单id获取售后单AfterSaleItem信息
 * @method getAfterSaleOrderDetailByParams(array $params) 售后单创建页面 - 获取零售订单商品明细
 * @method createByParams(array $params) 创建售后单
 * @method closeByParams(array $params) 根据售后单id关闭售后单
 * @method resubmitByParams(array $params) 根据售后单id，重新提交售后单
 * @method getByOrderIdByParams(array $params) 根据零售订单id获取零售 - 售后单
 * @method douYinRefundStatusCallBackByParams(array $params) 支付网关抖音退款结果回调
 */
class AfterSale {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Store\\Order\\AfterSale";

    /**
     * 根据订单id获取售后单AfterSaleItem信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAfterSaleItemsByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleItemsByOrderId(["orderId" => $orderId]);
    }

    /**
     * 售后单创建页面 - 获取零售订单商品明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAfterSaleOrderDetail (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleOrderDetail(["orderId" => $orderId]);
    }

    /**
     * 创建售后单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create (int $orderId, string $type, string $reason, int $isStaffPay = 0, string $from, int $createType = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "type" => $type, "reason" => $reason, "isStaffPay" => $isStaffPay, "from" => $from, "createType" => $createType]);
    }

    /**
     * 根据售后单id关闭售后单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id]);
    }

    /**
     * 根据售后单id，重新提交售后单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function resubmit (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resubmit(["id" => $id]);
    }

    /**
     * 根据零售订单id获取零售 - 售后单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByOrderId(["orderId" => $orderId]);
    }

    /**
     * 支付网关抖音退款结果回调
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function douYinRefundStatusCallBack (string $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->douYinRefundStatusCallBack(["data" => $data]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}