<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-25 09:33:21
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class UserImages
 * @method batchCreateByParams(array $params) 用户上传图片
 * @method listByParams(array $params) 用户图片列表-不分页
 * @method listWithPaginatorByParams(array $params) 用户图片列表-分页
 * @method batchDeleteByParams(array $params) 删除图片
 * @method photosPaginatorByParams(array $params) 用户中心，我的照片列表-分页
 * @method himoPhotosListByParams(array $params) 用户中心，海马体成片列表-不分页
 */
class UserImages {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\UserImages";

    /**
     * 用户上传图片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchCreate (array $images) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreate(["images" => $images]);
    }

    /**
     * 用户图片列表-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 用户图片列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listWithPaginator (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginator(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 删除图片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchDelete (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDelete(["ids" => $ids]);
    }

    /**
     * 用户中心，我的照片列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function photosPaginator (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->photosPaginator(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 用户中心，海马体成片列表-不分页
     * @return  array
    */
    public static function himoPhotosList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->himoPhotosList();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}