<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-25 09:33:21
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductV2
 * @method createAddedProductByParams(array $params) 创建增值服务产品
 * @method updateAddedProductByParams(array $params) 更新增值服务产品
 * @method addedProductSkuBatchUpdateByParams(array $params) 批量创建增值服务产品sku
 * @method bindAddedSkuListByParams(array $params) 查看增值服务产品sku列表
 * @method bindAddedSkuByParams(array $params) 产品sku绑定/解绑增值服务
 * @method addedServiceCategoryListByParams(array $params) 查看增值服务分类列表
 * @method addedProductWithPaginatorByParams(array $params) 查看增值服务列表-分页
 * @method addedProductSkuListByParams(array $params) 查看当前增值服务下sku列表
 * @method addedProductDetailByParams(array $params) 查看增值服务详情
 * @method deleteAddedProductByParams(array $params) 删除增值服务spu
 * @method deleteAddedProductSkuByParams(array $params) 删除增值服务sku
 * @method productSkuPricePendingListByParams(array $params) sku价格审批列表
 * @method resubmitPricePendingByParams(array $params) 重新提交价格审批
 */
class ProductV2 {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\ProductV2";

    /**
     * 创建增值服务产品
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\CreateAddedProductDTO
    */
    public static function createAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $createAddedProductCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createAddedProduct($createAddedProductCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\CreateAddedProductDTO"
        );
    }

    /**
     * 更新增值服务产品
     * @return  bool
    */
    public static function updateAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $updateAddedProductCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateAddedProduct($updateAddedProductCmd);
    }

    /**
     * 批量创建增值服务产品sku
     * @return  bool
    */
    public static function addedProductSkuBatchUpdate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $addedProductSkuBatchUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addedProductSkuBatchUpdate($addedProductSkuBatchUpdateCmd);
    }

    /**
     * 查看增值服务产品sku列表
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\BindAddedSkuListDTO
    */
    public static function bindAddedSkuList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $bindAddedSkuListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bindAddedSkuList($bindAddedSkuListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\BindAddedSkuListDTO"
        );
    }

    /**
     * 产品sku绑定/解绑增值服务
     * @return  bool
    */
    public static function bindAddedSku (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuCmd $bindAddedSkuCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindAddedSku($bindAddedSkuCmd);
    }

    /**
     * 查看增值服务分类列表
     * @return  array
    */
    public static function addedServiceCategoryList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addedServiceCategoryList(),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedServiceCategoryListDTO[]"
        );
    }

    /**
     * 查看增值服务列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductsWithPaginatorDTO
    */
    public static function addedProductWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductsWithPaginatorCmd $addedProductsWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addedProductWithPaginator($addedProductsWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductsWithPaginatorDTO"
        );
    }

    /**
     * 查看当前增值服务下sku列表
     * @return  array
    */
    public static function addedProductSkuList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuListCmd $addedProductSkuListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addedProductSkuList($addedProductSkuListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedSkuDTO[]"
        );
    }

    /**
     * 查看增值服务详情
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductDTO
    */
    public static function addedProductDetail (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $addedProductDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addedProductDetail($addedProductDetailCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductDTO"
        );
    }

    /**
     * 删除增值服务spu
     * @return  bool
    */
    public static function deleteAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $addedProductDetailCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAddedProduct($addedProductDetailCmd);
    }

    /**
     * 删除增值服务sku
     * @return  bool
    */
    public static function deleteAddedProductSku (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\DeleteAddedProductSkuCmd $deleteAddedProductSkuCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAddedProductSku($deleteAddedProductSkuCmd);
    }

    /**
     * sku价格审批列表
     * @return  array
    */
    public static function productSkuPricePendingList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\SearchPricePendingCmd $searchPricePendingCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuPricePendingList($searchPricePendingCmd);
    }

    /**
     * 重新提交价格审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function resubmitPricePending (int $productSkuPricePendingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resubmitPricePending(["productSkuPricePendingId" => $productSkuPricePendingId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}