<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-25 09:33:21
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method createRandomByParams(array $params) 手动创建任务字符码
 * @method createByParams(array $params) 创建产品
 * @method updateByParams(array $params) 更新产品
 * @method productSkuBatchCreateByParams(array $params) 批量创建productSku
 * @method productSkuBatchUpdateByParams(array $params) 批量更新productSku
 * @method productOnByParams(array $params) 上架product
 * @method productOffByParams(array $params) 下架product
 * @method productSkuShelveByParams(array $params) 上架productSku
 * @method productSkuUnshelveByParams(array $params) 下架productSku
 * @method productDisableByParams(array $params) product停用
 * @method productEnableByParams(array $params) product启用
 * @method productSkuDisableByParams(array $params) productSku停用
 * @method productSkuEnableByParams(array $params) productSku启用
 * @method detailByParams(array $params) 产品详情-不带sku
 * @method detailWithSkuByParams(array $params) 产品详情-附带sku
 * @method getProductSkusByProductIdByParams(array $params) 根据productId获取下面所有的productSkus
 * @method allListByParams(array $params) 产品搜索查询-不分页
 * @method productSkuListByParams(array $params) 获取productSku-分页
 * @method updateCustomizedTemplateByParams(array $params) 上传sku模版psd
 * @method callbackOutSkuTemplateByParams(array $params) sku模版回调
 * @method callbackProductOrderItemByParams(array $params) 用户作品回调
 * @method searchProductListByParams(array $params) 产品搜索列表-各种条件的复杂查询
 * @method searchMaterialListByParams(array $params) 查询搜索列表-各种条件的复杂查询，只查询在供应链有数据的product
 * @method productSkuImportByParams(array $params) 商品sku信息导入
 * @method productSkuExportAddByParams(array $params) 商品sku信息导出
 * @method productSkuListWithPaginateByParams(array $params) 零售POS收银-productSku列表，该接口单独只给BMS端活动试算使用
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Product";

    /**
     * 手动创建任务字符码
     * @return  bool
    */
    public static function createRandom () {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRandom();
    }

    /**
     * 创建产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function create (int $type, int $categoryId, string $name, int $needCheckStock = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["type" => $type, "categoryId" => $categoryId, "name" => $name, "needCheckStock" => $needCheckStock]);
    }

    /**
     * 更新产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (int $id, int $categoryId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "categoryId" => $categoryId, "name" => $name]);
    }

    /**
     * 批量创建productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productSkuBatchCreate (int $productId, int $type, array $productSku, array $productExtendMetric) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuBatchCreate(["productId" => $productId, "type" => $type, "productSku" => $productSku, "productExtendMetric" => $productExtendMetric]);
    }

    /**
     * 批量更新productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productSkuBatchUpdate (int $productId, int $type, array $productSku, array $productExtendMetric) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuBatchUpdate(["productId" => $productId, "type" => $type, "productSku" => $productSku, "productExtendMetric" => $productExtendMetric]);
    }

    /**
     * 上架product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productOn (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOn(["productId" => $productId]);
    }

    /**
     * 下架product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productOff (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOff(["productId" => $productId]);
    }

    /**
     * 上架productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productSkuShelve (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuShelve(["productSkuId" => $productSkuId]);
    }

    /**
     * 下架productSku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productSkuUnshelve (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuUnshelve(["productSkuId" => $productSkuId]);
    }

    /**
     * product停用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productDisable (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDisable(["productId" => $productId]);
    }

    /**
     * product启用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productEnable (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productEnable(["productId" => $productId]);
    }

    /**
     * productSku停用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productSkuDisable (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDisable(["productSkuId" => $productSkuId]);
    }

    /**
     * productSku启用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function productSkuEnable (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuEnable(["productSkuId" => $productSkuId]);
    }

    /**
     * 产品详情-不带sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 产品详情-附带sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailWithSku (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithSku(["id" => $id]);
    }

    /**
     * 根据productId获取下面所有的productSkus
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductSkusByProductId (bool $isShowDisable = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkusByProductId(["isShowDisable" => $isShowDisable]);
    }

    /**
     * 产品搜索查询-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function allList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->allList([]);
    }

    /**
     * 获取productSku-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuList (int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 上传sku模版psd
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateCustomizedTemplate (int $skuId, string $templatePath) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCustomizedTemplate(["skuId" => $skuId, "templatePath" => $templatePath]);
    }

    /**
     * sku模版回调
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function callbackOutSkuTemplate (string $task_id, string $type, string $out_path, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackOutSkuTemplate(["task_id" => $task_id, "type" => $type, "out_path" => $out_path, "status" => $status]);
    }

    /**
     * 用户作品回调
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function callbackProductOrderItem (string $task_id, string $type, string $out_path, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackProductOrderItem(["task_id" => $task_id, "type" => $type, "out_path" => $out_path, "status" => $status]);
    }

    /**
     * 产品搜索列表-各种条件的复杂查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchProductList (bool $isShowDisable = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProductList(["isShowDisable" => $isShowDisable]);
    }

    /**
     * 查询搜索列表-各种条件的复杂查询，只查询在供应链有数据的product
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchMaterialList (bool $isShowDisable = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchMaterialList(["isShowDisable" => $isShowDisable]);
    }

    /**
     * 商品sku信息导入
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuImport (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuImport(["data" => $data]);
    }

    /**
     * 商品sku信息导出
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function productSkuExportAdd (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuExportAdd(["template_id" => $template_id]);
    }

    /**
     * 零售POS收银-productSku列表，该接口单独只给BMS端活动试算使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function productSkuListWithPaginate (int $storeId, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithPaginate(["storeId" => $storeId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}