<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-25 09:33:21
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CustomizedTheme
 * @method createByParams(array $params) 创建主题
 * @method updateByParams(array $params) 更新主题
 * @method detailByParams(array $params) 主题详情
 * @method deleteByParams(array $params) 主题删除
 * @method listWithPaginateByParams(array $params) 专题列表-分页
 * @method listByParams(array $params) 主题列表
 * @method groupListByParams(array $params) 主题分组列表
 * @method createThemeGroupByParams(array $params) 创建主题分组
 * @method updateThemeGroupByParams(array $params) 更新主题分组
 * @method deleteThemeGroupByParams(array $params) 删除主题分组
 * @method skuListWithPaginatorByParams(array $params) 创建主题筛选sku列表-分页
 * @method templateListWithPaginatorByParams(array $params) 创建主题可用模版列表-分页
 * @method componentItemListWithPaginatorByParams(array $params) 创建主题可用背景/贴图列表-分页
 * @method getThemePageRangeByParams(array $params) 创建/编辑主题获取书册页数范围
 * @method skuBindThemesByParams(array $params) sku绑定主题
 * @method skuUnbindThemesByParams(array $params) sku解绑主题
 */
class CustomizedTheme {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Customized\\CustomizedTheme";

    /**
     * 创建主题
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeCmd $createThemeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createThemeCmd);
    }

    /**
     * 更新主题
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeCmd $updateThemeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($updateThemeCmd);
    }

    /**
     * 主题详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO"
        );
    }

    /**
     * 主题删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 专题列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeListWithPaginateDTO
    */
    public static function listWithPaginate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListWithPaginateCmd $themeListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginate($themeListWithPaginateCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeListWithPaginateDTO"
        );
    }

    /**
     * 主题列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListCmd $themeListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($themeListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO[]"
        );
    }

    /**
     * 主题分组列表
     * @return  array
    */
    public static function groupList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->groupList(),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeGroupDTO[]"
        );
    }

    /**
     * 创建主题分组
     * @return  bool
    */
    public static function createThemeGroup (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeGroupCmd $createThemeGroupCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createThemeGroup($createThemeGroupCmd);
    }

    /**
     * 更新主题分组
     * @return  bool
    */
    public static function updateThemeGroup (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeGroupCmd $updateThemeGroupCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateThemeGroup($updateThemeGroupCmd);
    }

    /**
     * 删除主题分组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteThemeGroup (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteThemeGroup(["id" => $id]);
    }

    /**
     * 创建主题筛选sku列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\SkuListWithPaginatorDTO
    */
    public static function skuListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\SkuListWithPaginatorCmd $skuListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->skuListWithPaginator($skuListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\SkuListWithPaginatorDTO"
        );
    }

    /**
     * 创建主题可用模版列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\TemplateListWithPaginatorDTO
    */
    public static function templateListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\TemplateListWithPaginatorCmd $templateListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->templateListWithPaginator($templateListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\TemplateListWithPaginatorDTO"
        );
    }

    /**
     * 创建主题可用背景/贴图列表-分页
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemsWithPaginatorDTO
    */
    public static function componentItemListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginatorCmd $componentItemListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->componentItemListWithPaginator($componentItemListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemsWithPaginatorDTO"
        );
    }

    /**
     * 创建/编辑主题获取书册页数范围
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getThemePageRange (array $productSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getThemePageRange(["productSkuIds" => $productSkuIds]);
    }

    /**
     * sku绑定主题
     * @return  bool
    */
    public static function skuBindThemes (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\SkuBindThemesCmd $skuBindThemesCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuBindThemes($skuBindThemesCmd);
    }

    /**
     * sku解绑主题
     * @return  bool
    */
    public static function skuUnbindThemes (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\SkuBindThemesCmd $skuBindThemesCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuUnbindThemes($skuBindThemesCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}