<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:50:48
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CustomizedV2
 */
class CustomizedV2 {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Product\\CustomizedV2";

    /**
     * 获取产品sku下所有主题数据
     */
    public static function getSkuThemeList (int $skuId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuThemeList(["skuId" => $skuId, ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeListDTO[]"
        );
    }
    /**
     * 获取sku的主题详情信息
     */
    public static function getThemeTemplateDetail (int $skuId, int $themeId): \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeTemplateDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getThemeTemplateDetail(["skuId" => $skuId, "themeId" => $themeId, ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeTemplateDetailDTO"
        );
    }
    /**
     * 获取sku的加页增值服务，带增页模版信息
     */
    public static function getAddPageSkuAndTemplate (int $skuId, int $themeId): \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetAddPageSkuAndTemplateDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAddPageSkuAndTemplate(["skuId" => $skuId, "themeId" => $themeId, ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetAddPageSkuAndTemplateDTO"
        );
    }
    /**
     * 获取当前sku模版和增值服务、贴图、背景数据信息
     */
    public static function getSkuTemplateWorkDetail (int $skuId, int $themeId, int $orderId = 0, int $orderItemId = 0, string $templateType): \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetSkuTemplateWorkDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuTemplateWorkDetail(["skuId" => $skuId, "themeId" => $themeId, "orderId" => $orderId, "orderItemId" => $orderItemId, "templateType" => $templateType, ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetSkuTemplateWorkDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}