<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:50:48
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Pay;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Pay
 */
class Pay {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Pay\\Pay";

    /**
     * 定制小程序-创建支付单
     */
    public static function create (string $orderNum, float $payMoney, string $openId, array $extend): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderNum" => $orderNum, "payMoney" => $payMoney, "openId" => $openId, "extend" => $extend, ]);
    }
    /**
     * 支付回调
     */
    public static function callback (string $data): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callback(["data" => $data, ]);
    }
    /**
     * 门店定制0元设置支付成功
     */
    public static function zeroSetPaid (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->zeroSetPaid(["id" => $id, ]);
    }
    /**
     * 支付回调，仅用于release，dev，pre环境调试使用，支付方式:现金
     */
    public static function callbackCash (int $id, float $money): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackCash(["id" => $id, "money" => $money, ]);
    }
    /**
     * 关闭支付订单
     */
    public static function close (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["orderNum" => $orderNum, ]);
    }
    /**
     * 获取支付短链
     */
    public static function getPayShortLink (\Mainto\Bridge\Structs\ProjectRetail\Cmd\GetPayLinkCmd $getPayLinkCmd): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayShortLink($getPayLinkCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}