<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:50:48
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Coupon
 */
class Coupon {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\Coupon";

    /**
     * 用户中心获取用户优惠券
     */
    public static function getUserCoupons (array $status): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["status" => $status, ]);
    }
    /**
     * 用户绑定优惠券
     */
    public static function bindCouponCode (string $code): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindCouponCode(["code" => $code, ]);
    }
    /**
     * 根据不同场景绑定用户优惠卷
     */
    public static function bindUserCoupons (string $applyScene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserCoupons(["applyScene" => $applyScene, ]);
    }
    /**
     * 根据应用场景获取零售优惠券展示信息
     */
    public static function getCouponByScene (string $applyScene): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponByScene(["applyScene" => $applyScene, ]);
    }
    /**
     * 获取Sku有效优惠券
     */
    public static function getSkuEffectiveCoupons (array $products): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuEffectiveCoupons(["products" => $products, ]);
    }
    /**
     * 根据创建ids获取优惠券列表
     */
    public static function getCouponsListByIds (array $ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponsListByIds(["ids" => $ids, ]);
    }
    /**
     * 根据手机号批量绑定指定优惠券
     */
    public static function phoneBindCoupon (array $phones, int $templateId, string $stopUsage, string $startUsage, string $title, string $channel, float $discount): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->phoneBindCoupon(["phones" => $phones, "templateId" => $templateId, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "title" => $title, "channel" => $channel, "discount" => $discount, ]);
    }
    /**
     * 根据手机号批量绑定指定优惠券
     */
    public static function autoPhoneBindCoupon (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoPhoneBindCoupon();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}