<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:50:48
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Category
 */
class Category {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Category";

    /**
     * 创建零售产品品类
     */
    public static function create (string $name, string $entrance, string $code, int $parentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "entrance" => $entrance, "code" => $code, "parentId" => $parentId, ]);
    }
    /**
     * 编辑零售产品品类
     */
    public static function update (int $id, string $name, string $entrance, string $code): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "entrance" => $entrance, "code" => $code, ]);
    }
    /**
     * 批量编辑零售产品品类
     */
    public static function batchCreate (array $data): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreate(["data" => $data, ]);
    }
    /**
     * 批量编辑零售产品品类
     */
    public static function batchUpdate (array $data): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdate(["data" => $data, ]);
    }
    /**
     * 品类详情
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 删除品类
     */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id, ]);
    }
    /**
     * 批量删除
     */
    public static function batchRemove (array $ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchRemove(["ids" => $ids, ]);
    }
    /**
     * 所有品类信息
     */
    public static function all (bool $showDeleted = false): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["showDeleted" => $showDeleted, ]);
    }
    /**
     * 添加品类时获取类目N级树状列表/获取树状列表
     */
    public static function getCategoryTree (int $parentId = 0, string $entrance, int $depth = 0, bool $showDeleted): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryTree(["parentId" => $parentId, "entrance" => $entrance, "depth" => $depth, "showDeleted" => $showDeleted, ]);
    }
    /**
     * 根据品类id获取属性信息
     */
    public static function getPropertiesById (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPropertiesById(["id" => $id, ]);
    }
    /**
     * 批量导入品类
     */
    public static function batchCreateCategory (array $info) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreateCategory(["info" => $info, ]);
    }
    /**
     * 零售商品-新增导出任务
     */
    public static function newTask (string $template_id, array $params): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["template_id" => $template_id, "params" => $params, ]);
    }
    /**
     * 更改排序
     */
    public static function updateSort (array $info) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSort(["info" => $info, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}