<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:14:02
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 */
class User {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\User";

    /**
     * 用户收货地址查询
     */
    public static function userAddresses (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddresses();
    }
    /**
     * 用户收货地址创建
     */
    public static function userAddressCreate (string $name, string $phone, int $cityId, int $provinceId, int $districtId, string $addressDetail, bool $isDefaultAddress = false): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddressCreate(["name" => $name, "phone" => $phone, "cityId" => $cityId, "provinceId" => $provinceId, "districtId" => $districtId, "addressDetail" => $addressDetail, "isDefaultAddress" => $isDefaultAddress, ]);
    }
    /**
     * 用户收货地址更新
     */
    public static function userAddressUpdate (int $id, string $name, string $phone, int $cityId, int $provinceId, int $districtId, string $addressDetail, bool $isDefaultAddress): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddressUpdate(["id" => $id, "name" => $name, "phone" => $phone, "cityId" => $cityId, "provinceId" => $provinceId, "districtId" => $districtId, "addressDetail" => $addressDetail, "isDefaultAddress" => $isDefaultAddress, ]);
    }
    /**
     * 用户收货地址删除
     */
    public static function userAddressDelete (int $userAddressId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAddressDelete(["userAddressId" => $userAddressId, ]);
    }
    /**
     * 获取省市区三级数据
     */
    public static function addressTree (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->addressTree();
    }
    /**
     * 用户详情
     */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail();
    }
    /**
     * 通过手机号和短信验证码验证重置密码
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->forgetUserPassword(["phone" => $phone, "password" => $password, "captcha" => $captcha, ]);
    }
    /**
     * 用户id通过分销功能绑定员工id
     */
    public static function bindStaffId (int $staffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindStaffId(["staffId" => $staffId, ]);
    }
    /**
     * 通过员工token信息获取小程序二维码base64字符串
     */
    public static function createWxMiniCode (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->createWxMiniCode();
    }
    /**
     * 创建通用二维码
     */
    public static function createWxQrCode (string $scene, array $optional): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->createWxQrCode(["scene" => $scene, "optional" => $optional, ]);
    }
    /**
     * 用户中心图片和作品展示
     */
    public static function userImageAndComposition (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->userImageAndComposition();
    }
    /**
     * 用户中心统计订单、优惠券、图片、作品个数
     */
    public static function userArrangeData (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->userArrangeData();
    }
    /**
     * 通过员工token信息获取绑定用户id列表
     */
    public static function getUserIdsByStaffId (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserIdsByStaffId();
    }
    /**
     * 通过员工token信息获取销售业绩列表
     */
    public static function getStaffOrders (string $appointHour, string $createTimeStart, string $createTimeEnd): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffOrders(["appointHour" => $appointHour, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, ]);
    }
    /**
     * 根据手机号获取用户信息
     */
    public static function getUserInfo (string $phone): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfo(["phone" => $phone, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}