<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:14:02
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Coupon
 */
class Coupon {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Coupon";

    /**
     * 获取优惠券创建列表
     */
    public static function getCouponCreateLogs (string $type, string $applyIn = 'retail', string $ids, string $createdAtEnd, string $createdAtStart, int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponCreateLogs(["type" => $type, "applyIn" => $applyIn, "ids" => $ids, "createdAtEnd" => $createdAtEnd, "createdAtStart" => $createdAtStart, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取优惠券模版列表-分页
     */
    public static function getTemplateList (string $type, string $applyIn = 'retail', string $name, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateList(["type" => $type, "applyIn" => $applyIn, "name" => $name, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取优惠券模版列表
     */
    public static function selectTemplates (string $type, string $applyIn = 'retail', string $name, array $ids, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->selectTemplates(["type" => $type, "applyIn" => $applyIn, "name" => $name, "ids" => $ids, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 作废优惠券
     */
    public static function abolishCoupons (array $ids, string $type = 'handle', array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCoupons(["ids" => $ids, "type" => $type, "extend" => $extend, ]);
    }
    /**
     * 删除优惠券配置信息
     */
    public static function deleteSettingCoupon (int $id, array $ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSettingCoupon(["id" => $id, "ids" => $ids, ]);
    }
    /**
     * 查看模版详情
     */
    public static function getTemplateInfo (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateInfo(["id" => $id, ]);
    }
    /**
     * 查看优惠卷码详情
     */
    public static function getCoupons (int $createLogId, string $applyIn = 'retail', string $status, string $codes, string $usedAtStart, string $usedStEnd, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoupons(["createLogId" => $createLogId, "applyIn" => $applyIn, "status" => $status, "codes" => $codes, "usedAtStart" => $usedAtStart, "usedStEnd" => $usedStEnd, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 创建优惠卷
     */
    public static function bulkGenerateCoupons (int $count, int $recordId, string $title, int $userId, string $status, int $templateId, string $buyChannel, float $discount, string $stopUsage, string $startUsage, string $applyScene, string $limit = 'compute', string $timeType = 'free', int $timeLong, array $extend, array $phones) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCoupons(["count" => $count, "recordId" => $recordId, "title" => $title, "userId" => $userId, "status" => $status, "templateId" => $templateId, "buyChannel" => $buyChannel, "discount" => $discount, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "applyScene" => $applyScene, "limit" => $limit, "timeType" => $timeType, "timeLong" => $timeLong, "extend" => $extend, "phones" => $phones, ]);
    }
    /**
     * 创建绑定单个用户优惠卷
     */
    public static function bindUserCoupons (int $count, int $recordId, string $title, string $status = 'unused', int $templateId, string $buyChannel = 'personal', float $discount, string $stopUsage, string $startUsage): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserCoupons(["count" => $count, "recordId" => $recordId, "title" => $title, "status" => $status, "templateId" => $templateId, "buyChannel" => $buyChannel, "discount" => $discount, "stopUsage" => $stopUsage, "startUsage" => $startUsage, ]);
    }
    /**
     * 创建优惠券模版
     */
    public static function createTemplate (string $name, string $type, array $limit, string $allSku = 'part', string $applyIn = 'retail', string $tagType = 'normal', array $extend): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTemplate(["name" => $name, "type" => $type, "limit" => $limit, "allSku" => $allSku, "applyIn" => $applyIn, "tagType" => $tagType, "extend" => $extend, ]);
    }
    /**
     * 更新优惠券模版
     */
    public static function templateUpdate (int $id, string $name, string $type, array $limit, string $applyIn = 'retail', array $extend, string $tagType = 'normal'): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->templateUpdate(["id" => $id, "name" => $name, "type" => $type, "limit" => $limit, "applyIn" => $applyIn, "extend" => $extend, "tagType" => $tagType, ]);
    }
    /**
     * 可用产品，所有零售商品列表
     */
    public static function getAllSkuByType (array $productIds, string $skuName, int $type = 4, array $types): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSkuByType(["productIds" => $productIds, "skuName" => $skuName, "type" => $type, "types" => $types, ]);
    }
    /**
     * 可用产品，所有零售商品列表
     */
    public static function getSkuIdsByType (int $type, array $types, array $productIds, string $skuName): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIdsByType(["type" => $type, "types" => $types, "productIds" => $productIds, "skuName" => $skuName, ]);
    }
    /**
     * 获取productSku-分页
     */
    public static function productSkuList (int $id, array $ids, int $productId, array $productIds, array $status, string $skuName, int $page = 1, int $pageSize = 20): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["id" => $id, "ids" => $ids, "productId" => $productId, "productIds" => $productIds, "status" => $status, "skuName" => $skuName, "page" => $page, "pageSize" => $pageSize, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}