<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-21 18:37:35
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AdjustPrice
 */
class AdjustPrice {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\AdjustPrice";

    /**
     * 创建调价单
     */
    public static function create (int $recordId, string $name, string $startAt, string $endAt, string $description, int $sellChannelId, array $storeGroupIds, array $storeIds, array $productSkus): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["recordId" => $recordId, "name" => $name, "startAt" => $startAt, "endAt" => $endAt, "description" => $description, "sellChannelId" => $sellChannelId, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds, "productSkus" => $productSkus, ]);
    }
    /**
     * 编辑调价单
     */
    public static function update (int $id, int $recordId, string $name, string $startAt, string $endAt, string $description, int $sellChannelId, array $storeGroupIds, array $storeIds, array $productSkus): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "recordId" => $recordId, "name" => $name, "startAt" => $startAt, "endAt" => $endAt, "description" => $description, "sellChannelId" => $sellChannelId, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds, "productSkus" => $productSkus, ]);
    }
    /**
     * 终止调价单
     */
    public static function stop (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->stop(["id" => $id, ]);
    }
    /**
     * 调价单详情
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 调价单列表
     */
    public static function list (int $id, string $name, string $status, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["id" => $id, "name" => $name, "status" => $status, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 校验创建条件单时批量导入的productSku数据合法性
     */
    public static function checkProductSkuImport (array $productSkus): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkProductSkuImport(["productSkus" => $productSkus, ]);
    }
    /**
     * 导出某个渠道所有的sku简略信息
     */
    public static function exportAdd (string $template_id, array $params): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportAdd(["template_id" => $template_id, "params" => $params, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}