<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 10:38:43
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductOrder
 */
class ProductOrder {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\ProductOrder";

    /**
     * 创建生产订单
     */
    public static function create (int $orderId, int $orderItemId, int $num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "orderItemId" => $orderItemId, "num" => $num, ]);
    }
    /**
     * 生产订单详情
     */
    public static function detail (int $productOrderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["productOrderId" => $productOrderId, ]);
    }
    /**
     * 获取跳转寸心编辑器的参数信息
     */
    public static function getEditorJumpParams (string $outOrderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEditorJumpParams(["outOrderNo" => $outOrderNo, ]);
    }
    /**
     * 设置用户著作单作品缩略图
     */
    public static function setUserCompositionThumbnail (int $productOrderId, string $thumbnailUrl, int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserCompositionThumbnail(["productOrderId" => $productOrderId, "thumbnailUrl" => $thumbnailUrl, "productId" => $productId, ]);
    }
    /**
     * 上传用户作品图
     */
    public static function updateUserImageInfo (int $productOrderItemId, array $userImage, string $status, string $description, string $name): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserImageInfo(["productOrderItemId" => $productOrderItemId, "userImage" => $userImage, "status" => $status, "description" => $description, "name" => $name, ]);
    }
    /**
     * 上传用户书册作品图
     */
    public static function updateUserOpusInfo (int $productOrderId, array $workImages, string $status, string $description, string $name): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserOpusInfo(["productOrderId" => $productOrderId, "workImages" => $workImages, "status" => $status, "description" => $description, "name" => $name, ]);
    }
    /**
     * 根据productOrderItemId查询用户作品，订单，和产品
     */
    public static function getProductOrderAndCompositionByproductOrderId (int $productOrderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductOrderAndCompositionByproductOrderId(["productOrderId" => $productOrderId, ]);
    }
    /**
     * 通过skuid获取第三方模版数据
     */
    public static function getOutTemplateBySkuId (int $productSkuId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOutTemplateBySkuId(["productSkuId" => $productSkuId, ]);
    }
    /**
     * 小程序草稿保存提交生产
     */
    public static function submitCreateProductOrder (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\SubmitCreateProductOrderCmd $submitCreateProductOrderCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitCreateProductOrder($submitCreateProductOrderCmd);
    }
    /**
     * 门店草稿提交直接提交生产
     */
    public static function storeSubmitCreateProductOrder (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\SubmitCreateProductOrderCmd $submitCreateProductOrderCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeSubmitCreateProductOrder($submitCreateProductOrderCmd);
    }
    /**
     * 上传用户制作原图
     */
    public static function updateOriginalImage (int $productOrderItemId, int $productOrderId, array $images): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOriginalImage(["productOrderItemId" => $productOrderItemId, "productOrderId" => $productOrderId, "images" => $images, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}