<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 10:38:43
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StoreGroup
 */
class StoreGroup {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\StoreGroup";

    /**
     * 设置零售商品售卖的门店或者门店组
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductStoreGroup(["ids" => $ids, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds, ]);
    }
    /**
     * 获取商品门店组信息
     */
    public static function getStoreGroupBySkuId (int $skuId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreGroupBySkuId(["skuId" => $skuId, ]);
    }
    /**
     * 清空商品skuId与门店、门店组关系
     */
    public static function clearStoreGroupBySkuId (int $skuId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearStoreGroupBySkuId(["skuId" => $skuId, ]);
    }
    /**
     * 删除商品与门店的关系
     */
    public static function deleteStoreGroupBySkuId (int $skuId, array $storeIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStoreGroupBySkuId(["skuId" => $skuId, "storeIds" => $storeIds, ]);
    }
    /**
     * 新增商品与门店组/门店管理
     */
    public static function addProductSkuStoreGroup (int $skuId, array $storeGroupIds = [], array $storeIds = []): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductSkuStoreGroup(["skuId" => $skuId, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds, ]);
    }
    /**
     * 创建门店组
     */
    public static function create (string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "remark" => $remark, "rule" => $rule, "whitelist" => $whitelist, "blacklist" => $blacklist, ]);
    }
    /**
     * 修改门店组
     */
    public static function update (int $id, string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "remark" => $remark, "rule" => $rule, "whitelist" => $whitelist, "blacklist" => $blacklist, ]);
    }
    /**
     * 门店组列表-分页
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 门店组列表-不分页
     */
    public static function listWithoutPaginate (string $name = ''): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithoutPaginate(["name" => $name, ]);
    }
    /**
     * 删除门店组
     */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id, ]);
    }
    /**
     * 获取全部门店组信息
     */
    public static function all (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->all();
    }
    /**
     * 门店搜索列表
     */
    public static function storeList (string $name, array $cityIds, array $storeTypes, array $area, int $page = 1, int $pageSize = 15): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeList(["name" => $name, "cityIds" => $cityIds, "storeTypes" => $storeTypes, "area" => $area, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 搜索所有门店-不分页
     */
    public static function getStores (string $name, array $cityIds, array $storeTypes, array $area): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStores(["name" => $name, "cityIds" => $cityIds, "storeTypes" => $storeTypes, "area" => $area, ]);
    }
    /**
     * 门店组详情-带有门店
     */
    public static function getStoreIdsByStoreGroupIds (array $storeGroupIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsByStoreGroupIds(["storeGroupIds" => $storeGroupIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}