<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 17:52:41
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Product\\Product";

    /**
     * 产品分页列表
     */
    public static function list (int $type, string $name, int $categoryId, array $categoryIds, int $brandId, array $status, string $startAt, int $onlineSales, int $offlineSales, int $needLabel, string $endAt, int $isCombine = 0, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["type" => $type, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "brandId" => $brandId, "status" => $status, "startAt" => $startAt, "onlineSales" => $onlineSales, "offlineSales" => $offlineSales, "needLabel" => $needLabel, "endAt" => $endAt, "isCombine" => $isCombine, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 根据商品id获取对应的sku信息
     */
    public static function getSkusByProduct (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByProduct(["id" => $id, ]);
    }
    /**
     * 获取物流和加急服务数据
     */
    public static function getExpressUrgentList (string $provinceName, array $detail, array $couponIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExpressUrgentList(["provinceName" => $provinceName, "detail" => $detail, "couponIds" => $couponIds, ]);
    }
    /**
     * 根据skuCode刷入渠道sku数据
     */
    public static function flashSellChannelProductAndSkuBySkuCode (array $skuCodes, int $sellChannelId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->flashSellChannelProductAndSkuBySkuCode(["skuCodes" => $skuCodes, "sellChannelId" => $sellChannelId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}