<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 17:52:41
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Group
 */
class Group {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Group";

    /**
     * 创建分组
     */
    public static function create (string $name, string $imageUrl, string $showPlace, int $sort = 0): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "imageUrl" => $imageUrl, "showPlace" => $showPlace, "sort" => $sort, ]);
    }
    /**
     * 更新分组
     */
    public static function update (int $id, string $name, string $imageUrl, string $showPlace, int $sort = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "imageUrl" => $imageUrl, "showPlace" => $showPlace, "sort" => $sort, ]);
    }
    /**
     * 删除分组
     */
    public static function delete (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id, ]);
    }
    /**
     * 分组列表
     */
    public static function list (string $showPlace): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["showPlace" => $showPlace, ]);
    }
    /**
     * 创建productId和groupId的绑定
     */
    public static function createProductAndGroupBinding (int $groupId, int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->createProductAndGroupBinding(["groupId" => $groupId, "productId" => $productId, ]);
    }
    /**
     * 批量创建productId和groupId的绑定
     */
    public static function batchCreateProductAndGroupBinding (int $groupId, array $productInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreateProductAndGroupBinding(["groupId" => $groupId, "productInfo" => $productInfo, ]);
    }
    /**
     * 更新productId和groupId的绑定
     */
    public static function updateProductAndGroupBinding (int $id, int $productId, int $groupId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductAndGroupBinding(["id" => $id, "productId" => $productId, "groupId" => $groupId, ]);
    }
    /**
     * 删除productId和groupId的绑定
     */
    public static function deleteProductAndGroupBinding (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteProductAndGroupBinding(["id" => $id, ]);
    }
    /**
     * 查询productId和groupId的绑定
     */
    public static function getProductAndGroupBinding (int $id, array $ids, int $groupId, array $groupIds, int $productId, array $productIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductAndGroupBinding(["id" => $id, "ids" => $ids, "groupId" => $groupId, "groupIds" => $groupIds, "productId" => $productId, "productIds" => $productIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}