<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 19:34:32
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Store\\Product\\Product";

    /**
     * 零售POS收银-productSku列表
     */
    public static function productSkuListWithPaginate (array $categoryIds, string $skuName, string $skuCode, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithPaginate(["categoryIds" => $categoryIds, "skuName" => $skuName, "skuCode" => $skuCode, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 零售POS收银-productSku详情
     */
    public static function productSkuDetail (int $sellChannelProductSkuId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDetail(["sellChannelProductSkuId" => $sellChannelProductSkuId, ]);
    }
    /**
     * 根据活动获取促销商品sku列表
     */
    public static function getPromotionProductSku (int $promotionId, string $skuName, int $isGiveaway, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPromotionProductSku(["promotionId" => $promotionId, "skuName" => $skuName, "isGiveaway" => $isGiveaway, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 根据skuCode扫码获取productSku
     */
    public static function getProductSkuBySkuCode (string $skuCode): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuBySkuCode(["skuCode" => $skuCode, ]);
    }
    /**
     * 根据门店id和skuIds获取对应的库存
     */
    public static function getStockBySkuIds (array $skuIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockBySkuIds(["skuIds" => $skuIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}