<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 19:34:32
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Project;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Project
 */
class Project {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Project\\Project";

    /**
     * 新增收集计划
     */
    public static function create (string $name, string $project_start, string $project_end, string $description, array $sku_info): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "project_start" => $project_start, "project_end" => $project_end, "description" => $description, "sku_info" => $sku_info, ]);
    }
    /**
     * 计划列表
     */
    public static function list (string $name, int $page, int $pageSize = 20): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * SKU导入验证
     */
    public static function productImport (array $skuIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productImport(["skuIds" => $skuIds, ]);
    }
    /**
     * 计划终止
     */
    public static function terminate (int $id): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->terminate(["id" => $id, ]);
    }
    /**
     * 计划详情
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 计划包含的SKU
     */
    public static function getSkuList (int $project_id, string $skuName, int $categoryId, int $page, int $pageSize = 20): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuList(["project_id" => $project_id, "skuName" => $skuName, "categoryId" => $categoryId, "page" => $page, "pageSize" => $pageSize, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}