<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 15:38:24
 */
namespace Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd;

class UpdateDiscountCmd {
    /**
     * @var  int
     * 活动id
     * validation: 
     */
    public int $id;
    /**
     * @var  int
     * 活动备案id
     * validation: 
     */
    public int $recordId;
    /**
     * @var  int
     * 活动层级id
     * validation: in:1,2,3,99
     */
    public int $levelId;
    /**
     * @var  string
     * 活动名称
     * validation: max:20
     */
    public string $name;
    /**
     * @var  string
     * 活动开始时间
     * validation: 
     */
    public string $startAt;
    /**
     * @var  string
     * 活动结束时间
     * validation: 
     */
    public string $endAt;
    /**
     * @var  null|array
     * 活动门店组数组
     * validation: 
     */
    public ?array $storeIdGroupIds = null;
    /**
     * @var  array
     * 活动门店数组
     * validation: 
     */
    public array $storeIds;
    /**
     * @var  string
     * 活动描述
     * validation: max:500
     */
    public string $description = "";
    /**
     * @var  string
     * 活动类型：decrease打折；discount满减；pack打包一口价；markUpGift加价购
     * validation: in:decrease,discount,pack,markUpGift
     */
    public string $type;
    /**
     * @var  array
     * 活动详细规则
     * validation: 
     */
    public array $rule = [];
    /**
     * @var  array
     * 前端样式json
     * validation: 
     */
    public array $metaData = [];
    /**
     * @var  array
     * 促销活动条件集sku信息：skuIds
     * validation: 
     */
    public array $discountCondition;
    /**
     * @var  array
     * 促销活动结果集skuIds信息和阶梯信息
     * validation: 
     */
    public array $discountResult;

    public function __construct (int $id = 0, int $recordId = 0, int $levelId = 0, string $name = '', string $startAt = '', string $endAt = '', array $storeIds = [], string $type = '', array $discountCondition = [], array $discountResult = []) {
        $this->id = $id;
        $this->recordId = $recordId;
        $this->levelId = $levelId;
        $this->name = $name;
        $this->startAt = $startAt;
        $this->endAt = $endAt;
        $this->storeIds = $storeIds;
        $this->type = $type;
        $this->discountCondition = $discountCondition;
        $this->discountResult = $discountResult;
    }

    public static function create(int $id = 0, int $recordId = 0, int $levelId = 0, string $name = '', string $startAt = '', string $endAt = '', array $storeIds = [], string $type = '', array $discountCondition = [], array $discountResult = []): self {
        return new self($id, $recordId, $levelId, $name, $startAt, $endAt, $storeIds, $type, $discountCondition, $discountResult);
    }

    public function setId(int $id): self {
        $this->id = $id;

        return $this;
    }

    public function setRecordId(int $recordId): self {
        $this->recordId = $recordId;

        return $this;
    }

    public function setLevelId(int $levelId): self {
        $this->levelId = $levelId;

        return $this;
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function setStartAt(string $startAt): self {
        $this->startAt = $startAt;

        return $this;
    }

    public function setEndAt(string $endAt): self {
        $this->endAt = $endAt;

        return $this;
    }

    public function setStoreIdGroupIds(?array $storeIdGroupIds): self {
        $this->storeIdGroupIds = $storeIdGroupIds;

        return $this;
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setDescription(string $description): self {
        $this->description = $description;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setRule(array $rule): self {
        $this->rule = $rule;

        return $this;
    }

    public function setMetaData(array $metaData): self {
        $this->metaData = $metaData;

        return $this;
    }

    public function setDiscountCondition(array $discountCondition): self {
        $this->discountCondition = $discountCondition;

        return $this;
    }

    public function setDiscountResult(array $discountResult): self {
        $this->discountResult = $discountResult;

        return $this;
    }
}