<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 15:38:24
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Order\\Order";

    /**
     * 根据订单编号修改售出伙伴id
     */
    public static function modifyOrderStaffIdByOrderNo (string $orderNo, int $inputStaffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyOrderStaffIdByOrderNo(["orderNo" => $orderNo, "inputStaffId" => $inputStaffId, ]);
    }
    /**
     * 商城订单-订单详情主表和子表不聚合
     */
    public static function detailItemScattered (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemScattered(["id" => $id, ]);
    }
    /**
     * 门店商城订单-订单详情
     */
    public static function storeDetailItems (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeDetailItems(["id" => $id, ]);
    }
    /**
     * 商城订单-订单详情主表和子表聚合
     */
    public static function detailItemAssociative (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemAssociative(["id" => $id, ]);
    }
    /**
     * 订单列表
     */
    public static function list (string $userPhone, string $orderNo, string $productOrderNo, string $userName, string $createTimeStart, string $createTimeEnd, string $status, string $source, int $storeId, array $statusList, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["userPhone" => $userPhone, "orderNo" => $orderNo, "productOrderNo" => $productOrderNo, "userName" => $userName, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "status" => $status, "source" => $source, "storeId" => $storeId, "statusList" => $statusList, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 订单列表
     */
    public static function storeList (string $userPhone, string $orderNo, string $productOrderNo, string $userName, string $createTimeStart, string $createTimeEnd, string $status, int $storeId, array $statusList, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeList(["userPhone" => $userPhone, "orderNo" => $orderNo, "productOrderNo" => $productOrderNo, "userName" => $userName, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "status" => $status, "storeId" => $storeId, "statusList" => $statusList, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 后台手动收货
     */
    public static function timingReceivedOrder (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->timingReceivedOrder(["id" => $id, ]);
    }
    /**
     * 订单列表导出
     */
    public static function orderListExportAdd (string $template_id = 'retail_orders_list_template', array $params): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderListExportAdd(["template_id" => $template_id, "params" => $params, ]);
    }
    /**
     * 零售订单详情
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 手动创建生成单
     */
    public static function manualCreateProductOrder (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualCreateProductOrder(["id" => $id, ]);
    }
    /**
     * 零售订单详情
     */
    public static function manualChangeOrderStatus (string $status, int $orderId, int $orderItemId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualChangeOrderStatus(["status" => $status, "orderId" => $orderId, "orderItemId" => $orderItemId, ]);
    }
    /**
     * oms异常单列表
     */
    public static function getOmsExceptionOrderList (string $omsOrderNo, int $page = 1, int $pageSize = 50): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOmsExceptionOrderList(["omsOrderNo" => $omsOrderNo, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 修改订单支付方式
     */
    public static function changePayType (int $id, string $payType, string $paymentNo = ''): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payType" => $payType, "paymentNo" => $paymentNo, ]);
    }
    /**
     * 根据订单id保存用户邮寄地址
     */
    public static function addOrderAddress (int $orderId, array $expressInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress(["orderId" => $orderId, "expressInfo" => $expressInfo, ]);
    }
    /**
     * 完成自提
     */
    public static function finishExpress (int $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishExpress(["itemId" => $itemId, ]);
    }
    /**
     * 设置订单完成支付
     */
    public static function setPaid (float $money, int $id, string $pay_type, string $payment_no = '', string $certificate = '', string $payment_time = ''): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["money" => $money, "id" => $id, "pay_type" => $pay_type, "payment_no" => $payment_no, "certificate" => $certificate, "payment_time" => $payment_time, ]);
    }
    /**
     * 发送零售业绩钉钉消息)
     */
    public static function dingNotifyStaffEffect (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dingNotifyStaffEffect(["id" => $id, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}