<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-24 11:18:49
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductSell
 */
class ProductSell {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\ProductSell";

    /**
     * 产品列表
     */
    public static function list (int $groupId, int $sellChannelId, int $type, array $categoryIds, string $productName, bool $isOnlyShelveUp = false): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["groupId" => $groupId, "sellChannelId" => $sellChannelId, "type" => $type, "categoryIds" => $categoryIds, "productName" => $productName, "isOnlyShelveUp" => $isOnlyShelveUp, ]);
    }
    /**
     * 产品列表-分页
     */
    public static function productListWithPaginate (int $groupId, int $sellChannelId = 5, array $categoryIds, string $productName, string $status = 'shelve', int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWithPaginate(["groupId" => $groupId, "sellChannelId" => $sellChannelId, "categoryIds" => $categoryIds, "productName" => $productName, "status" => $status, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取渠道product，不包含sku信息列表
     */
    public static function onlyProductList (int $sellChannelId = 5, string $productName, string $status = 'shelve'): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->onlyProductList(["sellChannelId" => $sellChannelId, "productName" => $productName, "status" => $status, ]);
    }
    /**
     * 每周精选热门产品列表-分页
     */
    public static function productListWeekSelection (int $sellChannelId = 5, string $status = 'shelve', int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWeekSelection(["sellChannelId" => $sellChannelId, "status" => $status, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 根据产品id获取产品和sku
     */
    public static function detailWithSku (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithSku(["id" => $id, ]);
    }
    /**
     * 根据产品id获取单个product
     */
    public static function getProductById (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id, ]);
    }
    /**
     * 根据产品id获取该产品所有的sku
     */
    public static function getProductSkuByProductId (int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuByProductId(["productId" => $productId, ]);
    }
    /**
     * 搜索product列表 - 分页
     */
    public static function searchProductListWithPaginate (string $productName, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProductListWithPaginate(["productName" => $productName, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 搜索热词列表
     */
    public static function searchKeywordsList (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchKeywordsList();
    }
    /**
     * 获取门店sku商品详情[暂不支持获取书册模版]
     */
    public static function storeSkuAndTemplateDetail (int $skuId, int $orderId = 0, int $orderItemId = 0): \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\storeSkuAndTemplateDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeSkuAndTemplateDetail(["skuId" => $skuId, "orderId" => $orderId, "orderItemId" => $orderItemId, ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\storeSkuAndTemplateDetailDTO"
        );
    }
    /**
     * 按照分组类型获取sku列表
     */
    public static function storeSkuListByGroup (string $showPlace = 'store_product_list'): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeSkuListByGroup(["showPlace" => $showPlace, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}